from spirecloudword import configuration
from spirecloudword.api.word_ai_api import WordAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
word_ai_api = WordAIApi(config)

def translate_document():
    name = "sample.docx"
    folder = "input"
    language = "Chinese"
    dest_file_path = "output/TranslateDocument.docx"
    try:
        word_ai_api.translate_document(name, language, dest_file_path, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def translate_document_with_encryption():
    name = "sample.docx"
    folder = "input"
    language = "Chinese"
    password = "123456"
    dest_file_path = "output/TranslateDocumentWithEncryption.docx"
    try:
        word_ai_api.translate_document(name, language, dest_file_path, folder = folder, password = password)
    except Exception as e:
        raise RuntimeError(e)

def translate_paragraph():
    name = "sample.docx"
    folder = "input"
    language = "Chinese"
    dest_file_path = "output/TranslateParagraph.docx"
    paragraph_path = "Section/0/Paragraph/2"
    try:
        word_ai_api.translate_paragraph(name, paragraph_path, language, dest_file_path, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def translate_text_range():
    name = "sample.docx"
    folder = "input"
    language = "Chinese"
    dest_file_path = "output/TranslateParagraph.docx"
    paragraph_path = "Section/0/Paragraph/2"
    index_of_range = 0
    try:
        word_ai_api.translate_text_range(name, paragraph_path, index_of_range, language, dest_file_path, folder = folder)
    except Exception as e:
        raise RuntimeError(e) 