import os
from spirecloudword import configuration
from spirecloudword.api.word_ai_api import WordAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
word_ai_api = WordAIApi(config)

def search_document():
    name = "sample.docx"
    folder = "input"
    question = "这篇文章讲了什么？ 请用中文回答："
    enable_history = False
    try:
        response = word_ai_api.search_document(name, question, folder = folder, enable_history = enable_history)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def search_document_enable_history():
    name = "sample.docx"
    folder = "input"
    question = "这篇文章讲了什么？ 请用中文回答："
    enable_history = True
    try:
        response = word_ai_api.search_document(name, question, folder = folder, enable_history = enable_history)
        dest_file_path = "local_output/SearchDocument_EnableHistory.txt"
        # 可写入文件
        # with open(dest_file_path, "w", encoding="utf-8") as f:
        #     f.write(response)
    except Exception as e:
        raise RuntimeError(e)

def search_document_enable_history_with_id():
    name = "sample.docx"
    folder = "input"
    question = "我刚才的问题要求什么语言回答？"
    enable_history = True
    conversation_id = get_conversation_id("local_output/SearchDocument_EnableHistory.txt")
    try:
        response = word_ai_api.search_document(name, question, folder = folder, enable_history = enable_history, conversation_id = conversation_id)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def search_document_unable_history():
    name = "sample.docx"
    folder = "input"
    question = "这篇文章讲了什么？ 请用中文回答："
    enable_history = False
    try:
        response = word_ai_api.search_document(name, question, folder = folder, enable_history = enable_history)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def search_document_unable_history_with_id():
    name = "sample.docx"
    folder = "input"
    question = "我刚才问了什么问题？"
    enable_history = False
    conversation_id = get_conversation_id("amy_output/SearchDocument_EnableHistory.txt")
    try:
        response = word_ai_api.search_document(name, question, folder = folder, enable_history = enable_history, conversation_id = conversation_id)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def search_document_options():
    name = "sample.docx"
    folder = "input"
    question = "这篇文章讲了什么？ 请用中文回答："
    password = "1234abcd"
    enable_history = False
    options = {"search_type": "similarity", "search_kwargs": "{\"k\": 10}"}
    try:
        response = word_ai_api.search_document(name, question, password = password, folder = folder, enable_history = enable_history, options = options)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def get_conversation_id(filename):
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 