import os
from spirecloudword import configuration
from spirecloudword.api.word_ai_api import WordAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
word_ai_api = WordAIApi(config)

def search():
    question = "Write a song about winter"
    language = "English"
    try:
        response = word_ai_api.search(question, language, enable_history = False)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def search_enable_history():
    question = "How many days are there in a year?"
    enable_history = True
    language = "English"
    try:
        response = word_ai_api.search(question, language, enable_history = enable_history)
        dest_file_path = "Search_EnableHistory.txt"
        # with open(dest_file_path, "w", encoding="utf-8") as f:
        #     f.write(response)
    except Exception as e:
        raise RuntimeError(e)

def search_enable_history_with_id():
    question = "What question did I ask?"
    enable_history = True
    language = "English"
    conversation_id = get_conversation_id("Search_EnableHistory.txt")
    try:
        response = word_ai_api.search(question, language, enable_history=enable_history, conversation_id=conversation_id)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def search_unable_history():
    question = "To recommend the way to play in spring, please return to markdown format"
    enable_history = False
    language = "English"
    try:
        response = word_ai_api.search(question, language, enable_history=enable_history)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def search_unable_history_with_id():
    question = "What question did I ask?"
    enable_history = False
    language = "English"
    conversation_id = get_conversation_id("Search_EnableHistory.txt")
    try:
        response = word_ai_api.search(question, language, enable_history=enable_history, conversation_id=conversation_id)
        # 可根据需要处理response
    except Exception as e:
        raise RuntimeError(e)

def get_conversation_id(filename):
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 