from spirecloudword import configuration
from spirecloudword.api.word_ai_api import WordAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
word_ai_api = WordAIApi(config)

def recognize_document_entities():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/RecognizeDocumentEntities.docx"
    language = "English"
    try:
        word_ai_api.recognize_document_entities(name, dest_file_path, language = language, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def recognize_document_entities_classifications():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/RecognizeDocumentEntities_classifications.docx"
    language = "English"
    classifications = ["City", "Food"]
    try:
        word_ai_api.recognize_document_entities(name, dest_file_path, language = language, classifications = classifications, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def recognize_entity_document_encryption():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/RecognizeEntityDocument_Encryption.docx"
    language = "English"
    password = "123456"
    try:
        word_ai_api.recognize_document_entities(name, dest_file_path, language = language, folder = folder, password = password)
    except Exception as e:
        raise RuntimeError(e)

def recognize_entity_paragraph():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/RecognizeEntityParagraph.docx"
    language = "English"
    paragraph_path = "Section/0/Paragraph/2"
    try:
        word_ai_api.recognize_paragraph_entities(name, paragraph_path, dest_file_path, language = language, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def recognize_entity_text_range():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/RecognizeEntityTextRange.docx"
    language = "English"
    paragraph_path = "Section/0/Paragraph/2"
    index_of_range = 0
    try:
        word_ai_api.recognize_text_range_entities(name, paragraph_path, index_of_range, dest_file_path, language = language, folder = folder)
    except Exception as e:
        raise RuntimeError(e) 