from spirecloudword import configuration
from spirecloudword.api.word_ai_api import WordAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
word_ai_api = WordAIApi(config)

def polish_document():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/PolishDocument.docx"
    try:
        word_ai_api.polish_document(name, dest_file_path, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def polish_document_encryption():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/PolishDocument_Encryption.docx"
    password = "1234abcd"
    try:
        word_ai_api.polish_document(name, dest_file_path, folder = folder, password = password)
    except Exception as e:
        raise RuntimeError(e)

def polish_document_language():
    name = "sample.docx"
    folder = "input"
    language = "English"
    dest_file_path = "output/PolishDocument_language.docx"
    try:
        word_ai_api.polish_document(name, dest_file_path, language = language, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def polish_paragraph():
    name = "sample.docx"
    folder = "input"
    paragraph_path = "Section/0/Paragraph/2"
    dest_file_path = "output/PolishParagraph.docx"
    try:
        word_ai_api.polish_paragraph(name, paragraph_path, dest_file_path, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def polish_text_range():
    name = "sample.docx"
    folder = "input"
    paragraph_path = "Section/0/Paragraph/2"
    index_of_range = 0
    dest_file_path = "output/PolishTextRange.docx"
    try:
        word_ai_api.polish_text_range(name, paragraph_path, index_of_range, dest_file_path, folder = folder)
    except Exception as e:
        raise RuntimeError(e) 