from spirecloudword import configuration
from spirecloudword.api.word_ai_api import WordAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
word_ai_api = WordAIApi(config)

def generate_abstract_document():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/GenerateAbstractDocument.docx"
    try:
        word_ai_api.generate_document_abstract(name, dest_file_path, folder=folder)
    except Exception as e:
        raise RuntimeError(e)

def generate_abstract_paragraph():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/GenerateAbstractParagraph.docx"
    paragraph_path = "Section/0/Paragraph/0"
    try:
        word_ai_api.generate_paragraph_abstract(name, paragraph_path, dest_file_path, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def generate_abstract_text_range():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/GenerateAbstractTextRange.docx"
    paragraph_path = "Section/0/Paragraph/0"
    index_of_range = 0
    try:
        word_ai_api.generate_text_range_abstract(name, paragraph_path, index_of_range, dest_file_path, folder = folder)
    except Exception as e:
        raise RuntimeError(e) 