from spirecloudword import configuration
from spirecloudword.api.word_ai_api import WordAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
word_ai_api = WordAIApi(config)

def check_spelling_document():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/CheckSpellingDocument.docx"
    language = "English"
    try:
        word_ai_api.check_document_spelling(name, dest_file_path, language = language, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def check_spelling_paragraph():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/CheckSpellingParagraph.docx"
    language = "English"
    paragraph_path = "Section/0/Paragraph/0"
    try:
        word_ai_api.check_paragraph_spelling(name, paragraph_path, dest_file_path, language = language, folder = folder)
    except Exception as e:
        raise RuntimeError(e)

def check_spelling_text_range():
    name = "sample.docx"
    folder = "input"
    dest_file_path = "output/CheckSpellingTextRange.docx"
    language = "English"
    paragraph_path = "Section/0/Paragraph/0"
    index_of_range = 0
    try:
        word_ai_api.check_text_range_spelling(name, paragraph_path, index_of_range, dest_file_path, language = language, folder = folder)
    except Exception as e:
        raise RuntimeError(e) 