import os
from spirecloudword import configuration
from spirecloudword.api.word_ai_api import WordAIApi

# 配置信息
base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
word_ai_api = WordAIApi(config)

def ask_enable_history():
    question = "一年有多少天？"
    enable_history = True
    try:
        response = word_ai_api.ask_question(question, enable_history = enable_history)
        with open("Ask_UnableHistory.txt", "w", encoding="utf-8") as f:
            f.write(response)
    except Exception as e:
        raise RuntimeError(e)

def ask_enable_history_with_id():
    question = "我刚才问了什么问?"
    enable_history = True
    conversation_id = get_conversation_id("Ask_EnableHistory.txt")
    try:
        response = word_ai_api.ask_question(question, enable_history = enable_history, conversation_id = conversation_id)
        with open("Ask_EnableHistoryWidthId.txt", "w", encoding="utf-8") as f:
            f.write(response)
    except Exception as e:
        raise RuntimeError(e)

def ask_unable_history():
    question = "推荐春天游玩的方式，请返回markdown格式"
    enable_history = False
    try:
        response = word_ai_api.ask_question(question, enable_history = enable_history)
        with open("Ask_UnableHistory.txt", "w", encoding="utf-8") as f:
            f.write(response)
    except Exception as e:
        raise RuntimeError(e)

def ask_unable_history_with_id():
    question = "刚才问了什么?"
    enable_history = False
    try:
        conversation_id = get_conversation_id("Ask_UnableHistory.txt")
        response = word_ai_api.ask_question(question, enable_history = enable_history, conversation_id = conversation_id)
        with open("Ask_UnableHistoryWidthId.txt", "w", encoding="utf-8") as f:
            f.write(response)
    except Exception as e:
        raise RuntimeError(e)

def get_conversation_id(filename):
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 
