from spirecloudpowerpoint import configuration
from spirecloudpowerpoint.api.powerpoint_ai_api import PowerPointAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
ppt_ai_api = PowerPointAIApi(config)


def search_enable_history():
    file_name = "Search_EnableHistory.txt"
    question = "how we can add a clickable URL to the Image as well?"
    language = "Chinese"
    enable_history = True
    folder = "output"
    try:
        ppt_ai_api.search(name = file_name, question=question, language=language, enable_history = enable_history, conversation_id = None, folder = folder, storage = None)
    except Exception as e:
        raise RuntimeError(e)


def search_enable_history_with_id():
    file_name = "Search_EnableHistoryWithId.txt"
    question = "我刚刚提到了什么？"
    language = "Chinese"
    enable_history = True
    conversation_id = get_conversation_id("output/Search_EnableHistory.txt")
    folder = "input"
    try:
        ppt_ai_api.search(name = file_name, question=question, language=language, enable_history = enable_history, conversation_id = conversation_id, folder = folder, storage = None)
    except Exception as e:
        raise RuntimeError(e)


def search_unable_history():
    file_name = "Search_UnableHistory.txt"
    question = "how we can add a clickable URL to the Image as well?"
    language = "English"
    enable_history = False
    folder = "output"
    try:
        ppt_ai_api.search(name = file_name, question=question, language=language, enable_history = enable_history, conversation_id = None, folder = folder, storage = None)
    except Exception as e:
        raise RuntimeError(e)


def search_unable_history_with_id():
    file_name = "Search_UnableHistoryWithId.txt"
    question = "我刚刚提到了什么？"
    language = "English"
    enable_history = False
    conversation_id = get_conversation_id("output/Search_EnableHistory.txt")
    folder = "output"
    try:
        ppt_ai_api.search(name = file_name, question=question, language=language, enable_history = enable_history, conversation_id = conversation_id, folder = folder, storage = None)
    except Exception as e:
        raise RuntimeError(e)


def get_conversation_id(filename):
    import os
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 