from spirecloudpowerpoint import configuration
from spirecloudpowerpoint.api.powerpoint_ai_api import PowerPointAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
ppt_ai_api = PowerPointAIApi(config)


def document_search_enable_history():
    file_name = "sample.pptx"
    dest_file_path = "output/SearchDocument_EnableHistory.txt"
    question = "这篇文章讲了什么？ 请用中文回答："
    enable_history = True
    folder = "input"
    try:
        ppt_ai_api.document_search(file_name, dest_file_path, question,  options = None, enable_history = enable_history, conversation_id = None, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def document_search_enable_history_with_id():
    file_name = "sample.pptx"
    dest_file_path = "output/SearchDocument_EnableHistoryWithId.txt"
    question = "我刚才的问题要求什么语言回答？"
    enable_history = True
    folder = "input"
    conversation_id = get_conversation_id("output/SearchDocument_EnableHistory.txt")
    try:
        ppt_ai_api.document_search(file_name, dest_file_path, question, options = None, enable_history = enable_history, conversation_id = conversation_id, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def document_search_unable_history():
    file_name = "sample.pptx"
    dest_file_path = "output/SearchDocument_UnableHistory.txt"
    question = "这篇文章讲了什么？ 请用中文回答："
    enable_history = False
    folder = "input"
    try:
        ppt_ai_api.document_search(file_name, dest_file_path, question, options = None, enable_history = enable_history, conversation_id = None, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def document_search_unable_history_with_id():
    file_name = "sample.pptx"
    dest_file_path = "output/SearchDocument_UnableHistory.txt"
    question = "我刚才问了什么问题？"
    enable_history = False
    folder = "input"
    conversation_id = get_conversation_id("output/SearchDocument_EnableHistory.txt")
    try:
        ppt_ai_api.document_search(file_name, dest_file_path, question, options = None, enable_history = enable_history, conversation_id = conversation_id, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def document_search_options():
    file_name = "sample.pptx"
    dest_file_path = "output/DocumentSearch_Options.txt"
    question = "这篇文章讲了什么？ 请用中文回答："
    enable_history = False
    folder = "input"
    options = {"search_type": "similarity", "search_kwargs": "{\"k\": 10}"}
    try:
        ppt_ai_api.document_search(file_name, dest_file_path, question, options = options, enable_history = enable_history, conversation_id = None, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def get_conversation_id(filename):
    import os
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 