from spirecloudpdf import configuration
from spirecloudpdf.api.pdf_ai_api import PdfAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
pdf_ai_api = PdfAIApi(config)


def search_enable_history():
    name = "search_EnableHistory.txt"
    language = "chinese"
    question = "如何提高居民消费欲望,请列举三点"
    folder = "output"
    enable_history = True
    try:
        pdf_ai_api.search(name, question, language = language, enable_history = enable_history, conversation_id = None, folder = folder, storage = None)
    except Exception as e:
        raise RuntimeError(e)


def search_enable_history_with_id():
    name = "search_EnableHistoryWithId.txt"
    question = "我刚刚提到了什么？"
    language = "English"
    enable_history = True
    folder = "output"
    conversation_id = get_conversation_id("output/search_EnableHistory.txt")
    try:
        pdf_ai_api.search(name, question, language = language, enable_history = enable_history, conversation_id = conversation_id, folder = folder, storage = None)
    except Exception as e:
        raise RuntimeError(e)


def search_unable_history():
    name = "search_UnableHistory.txt"
    question = "how we can add a clickable URL to the Image as well?"
    language = "Chinese"
    folder = "output"
    enable_history = False
    try:
        pdf_ai_api.search(name, question, language = language, enable_history = enable_history, conversation_id = None, folder = folder, storage = None)
    except Exception as e:
        raise RuntimeError(e)


def search_unable_history_with_id():
    name = "search_UnableHistoryWithId.txt"
    question = "我刚刚提到了什么？"
    language = "Chinese"
    folder = "output"
    enable_history = False
    conversation_id = get_conversation_id("output/search_EnableHistory.txt")
    try:
        pdf_ai_api.search(name, question, language = language, enable_history = enable_history, conversation_id = conversation_id, folder = folder, storage = None)
    except Exception as e:
        raise RuntimeError(e)


def get_conversation_id(filename):
    import os
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 