from spirecloudpdf import configuration
from spirecloudpdf.api.pdf_ai_api import PdfAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
pdf_ai_api = PdfAIApi(config)


def document_search_enable_history():
    name = "孔乙己.pdf"
    dest_file_path = "output/DocumentSearch_EnableHistory.txt"
    question = "这篇文章讲了什么？ 请用中文回答："
    enable_history = True
    folder = "input"
    try:
        pdf_ai_api.document_search(name, dest_file_path, question, enable_history = enable_history, conversation_id = None,password = None, folder = folder,storage = None)
    except Exception as e:
        raise RuntimeError(e)


def document_search_enable_history_with_id():
    name = "孔乙己.pdf"
    dest_file_path = "output/DocumentSearch_EnableHistoryWithId.txt"
    question = "我刚才的问题要求什么语言回答？"
    enable_history = True
    conversation_id = get_conversation_id("output/DocumentSearch_EnableHistory.txt")
    folder = "input"
    try:
        pdf_ai_api.document_search(name, dest_file_path, question, enable_history = enable_history, conversation_id = conversation_id,password = None, folder = folder,storage = None)
    except Exception as e:
        raise RuntimeError(e)


def document_search_unable_history():
    name = "孔乙己.pdf"
    dest_file_path = "output/DocumentSearch_EnableHistoryWithId.txt"
    question = "这篇文章讲了什么？ 请用中文回答："
    enable_history = False
    folder = "input"
    try:
        pdf_ai_api.document_search(name, dest_file_path, question, enable_history = enable_history, conversation_id = None, password = None, folder = folder,storage = None)
    except Exception as e:
        raise RuntimeError(e)


def document_search_unable_history_with_id():
    name = "孔乙己.pdf"
    dest_file_path = "output/DocumentSearch_UnableHistoryWithId.txt"
    question = "我刚才问了什么问题？"
    enable_history = False
    conversation_id = get_conversation_id("output/DocumentSearch_EnableHistory.txt")
    folder = "input"
    try:
        pdf_ai_api.document_search(name, dest_file_path, question, enable_history = enable_history, conversation_id = conversation_id, password = None, folder = folder,storage = None)
    except Exception as e:
        raise RuntimeError(e)


def document_search_encryption():
    name = "Encryption.pdf"
    dest_file_path = "output/DocumentSearch_Encryption.txt"
    question = "这篇文章讲了什么？请用中文回答："
    enable_history = True
    conversation_id = get_conversation_id("output/DocumentSearch_EnableHistory.txt")
    folder = "input"
    password = "123456"
    try:
        pdf_ai_api.document_search(name, dest_file_path, question, enable_history = enable_history, conversation_id = conversation_id, password = password, folder = folder,storage = None)
    except Exception as e:
        raise RuntimeError(e)


def get_conversation_id(filename):
    import os
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 