from spirecloudpdf import configuration
from spirecloudpdf.api.pdf_ai_api import PdfAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
pdf_ai_api = PdfAIApi(config)


def ask_enable_history():
    name = "Ask_EnableHistory.txt"
    question = "推荐春天游玩的方式，请返回markdown格式"
    enable_history = True
    folder = "output"
    try:
        pdf_ai_api.ask(name, question, enable_history = enable_history, conversation_id = None, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def ask_enable_history_with_id():
    name = "Ask_EnableHistoryWithId.txt"
    question = "我刚才问了关于春天的什么？"
    enable_history = True
    folder = "output"
    conversation_id = get_conversation_id("output/Ask_EnableHistory.txt")
    try:
        pdf_ai_api.ask(name, question, enable_history = enable_history, conversation_id = conversation_id, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def ask_unable_history():
    name = "Ask_UnableHistory.txt"
    question = "推荐春天游玩的方式，请返回markdown格式？"
    enable_history = False
    folder = "output"
    try:
        pdf_ai_api.ask(name, question, enable_history = enable_history, conversation_id = None, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def ask_unable_history_with_id():
    name = "Ask_UnableHistoryWithId.txt"
    question = "刚才问了什么？"
    enable_history = False
    folder = "output"
    conversation_id = get_conversation_id("output/Ask_EnableHistory.txt")
    try:
        pdf_ai_api.ask(name, question, enable_history = enable_history, conversation_id = conversation_id, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def get_conversation_id(filename):
    import os
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 