from spirecloudexcel import configuration
from spirecloudexcel.api.excel_ai_api import ExcelAIApi

base_url = "base url"
app_id = "your ai id"
app_key = "your ai key"

config = configuration.Configuration(app_id, app_key, base_url)
excel_ai_api = ExcelAIApi(config)


def ask_enable_history():
    name = "Ask_EnableHistory.txt"
    question = "推荐春天游玩的方式，请返回markdown格式"
    enable_history = True
    folder = "output"
    conversationID = ""
    try:
        excel_ai_api.ask(name, question, enable_history = enable_history, conversation_id = conversationID, folder=folder)
    except Exception as e:
        raise RuntimeError(e)


def ask_enable_history_with_id():
    name = "Ask_EnableHistoryWithId.txt"
    question = "我刚才问了关于春天的什么？"
    enable_history = True
    folder = "output"
    
    conversationID = get_conversation_id("output/Ask_EnableHistory.txt")
    try:
        excel_ai_api.ask(name, question, enable_history = enable_history, conversation_id = conversationID, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def ask_unable_history():
    name = "Ask_UnableHistory.txt"
    question = "推荐春天游玩的方式，请返回markdown格式"
    enable_history = False
    folder = "output"
    conversationID = ""
    try:
        excel_ai_api.ask(name, question, enable_history = enable_history, conversation_id = conversationID, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def ask_unable_history_with_id():
    name = "Ask_UnableHistoryWithId.txt"
    question = "刚才问了什么？"
    enable_history = False
    folder = "output"
    conversationID = get_conversation_id("output/Ask_UnableHistory.txt")
    try:
        excel_ai_api.ask(name, question, enable_history = enable_history, conversation_id = conversationID, folder = folder)
    except Exception as e:
        raise RuntimeError(e)


def get_conversation_id(filename):
    import os
    if not os.path.exists(filename):
        return None
    last_line = None
    with open(filename, "r", encoding="utf-8") as f:
        for line in f:
            last_line = line.strip()
    if last_line:
        parts = last_line.split(":")
        if len(parts) > 0:
            return parts[-1].strip()
    return None 

if __name__ == "__main__":
    print("开始测试 ask_enable_history...")
    ask_enable_history()
    print("测试完成！")