﻿using Newtonsoft.Json.Linq;
using Spire.Cloud.Word.Sdk.Api;
using Spire.Cloud.Word.Sdk.Client;
using System.IO;
using System;
using System.Collections.Generic;

namespace SpireCloudSDK
{
    class SearchDocument
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration wordConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

        public static void SearchDocument_()
        {
            string name = "sample.docx";
            string folder = "input";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            string response = wordAIApi.SearchDocument(name, question, folder, null, null, null, null);
        }
        public static void SearchDocument_EnableHistory()
        {
            string name = "sample.docx";
            string folder = "input";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            bool enableHistory = true;
            string response =wordAIApi.SearchDocument(name, question, folder, null, null, null, enableHistory, null);

            string destFilePath = "local_output/SearchDocument_EnableHistory.txt";
            File.WriteAllText(response, destFilePath);
        }
        public static void SearchDocument_EnableHistoryWidthId()
        {
            string name = "sample.docx";
            string folder = "input";
            string question = "我刚才的问题要求什么语言回答？";
            bool enableHistory = true;
            string conversationID = GetConversationID("local_output/SearchDocument_EnableHistory.txt");

            string response = wordAIApi.SearchDocument(name, question, folder, null, null, null, enableHistory, conversationID);
        }
        public static void SearchDocument_UnableHistory()
        {
            string name = "sample.docx";
            string folder = "input";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            bool enableHistory = false;;

            string response = wordAIApi.SearchDocument(name, question, folder, null, null, null, enableHistory, null);
        }
        public static void SearchDocument_UnableHistoryWithId()
        {
            string name = "sample.docx";
            string folder = "input";
            string question = "我刚才问了什么问题？";
            bool enableHistory = false;
            string conversationID = GetConversationID("amy_output/SearchDocument_EnableHistory.txt");

            string response = wordAIApi.SearchDocument(name, question, folder, null, null, null, enableHistory, null);
        }


        public static void SearchDocument_Options()
        {
            string name = "sample.docx";
            string folder = "input";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            string password = "1234abcd";
            bool enableHistory = false;
            var options = new Dictionary<string, string>();
            options.Add("search_type", "similarity");
            options.Add("search_kwargs", "{\"k\": 10}");

            string response = wordAIApi.SearchDocument(name, question, folder, null, password, options, enableHistory, null);
        }

        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}
