﻿using Spire.Cloud.Word.Sdk.Api;
using Spire.Cloud.Word.Sdk.Client;

namespace SpireCloudSDK
{
    class RecognizeEntity
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration wordConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl);
        static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

        public static void RecognizeDocumentEntities()
        {
            string name = "sample.docx";
            string folder = "input";
            string destFilePath = "output/RecognizeDocumentEntities.docx";
            string language = "English";

            wordAIApi.RecognizeDocumentEntities(name, destFilePath, language, null, folder, null, null);
        }

        public static void RecognizeDocumentEntities_classifications()
        {
            string name = "sample.docx";
            string folder = "input";
            string destFilePath = "output/RecognizeDocumentEntities_classifications.docx";
            string language = "English";
            string[] classifications = new string[] { "City", "Food" };

            wordAIApi.RecognizeDocumentEntities(name, destFilePath, language, classifications, folder, null, null);
        }

        public static void RecognizeEntityDocument_Encryption()
        {
            string name = "sample.docx";
            string folder = "input";
            string destFilePath = "output/RecognizeEntityDocument_Encryption.docx";
            string language = "English";
            string password = "123456";

            wordAIApi.RecognizeDocumentEntities(name, destFilePath, language, null, folder, null, password);
        }
        public static void RecognizeEntityParagraph()
        {
            string name = "sample.docx";
            string folder = "input";
            string destFilePath = "output/RecognizeEntityParagraph.docx";
            string language = "English";
            string paragraphPath = "Section/0/Paragraph/2";

            wordAIApi.RecognizeParagraphEntities(name, paragraphPath, destFilePath, language, null, folder, null, null);
        }

        public static void RecognizeEntityTextRange()
        {
            string name = "sample.docx";
            string folder = "input";
            string destFilePath = "output/RecognizeEntityTextRange.docx";
            string language = "English";
            string paragraphPath = "Section/0/Paragraph/2";
            int indexOfRange = 0;

            wordAIApi.RecognizeTextRangeEntities(name, paragraphPath, indexOfRange, destFilePath, language, null, folder, null, null);
        }
    }
}
