﻿using Newtonsoft.Json.Linq;
using Spire.Cloud.Powerpoint.Sdk.Api;
using Spire.Cloud.Powerpoint.Sdk.Client;
using System.IO;
using System;

namespace SpireCloudSDK
{
    class Search_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration pptConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static PowerPointAIApi pptAIApi = new PowerPointAIApi(pptConfiguration_AI);

        public static void Search()
        {
            string fileName = "Search.txt";
            string question = "茴香豆的茴字有几种写法？ 请用中文回答：";
            string language = "Chinese";
            string folder = "output";
            pptAIApi.SearchWithHttpInfo(fileName, question, language, null, null, folder);
        }

        public static void Search_EnableHistory()
        {
            string fileName = "Search_EnableHistory.txt";
            string question = "how we can add a clickable URL to the Image as well?";
            string language = "Chinese";
            bool enableHistory = true;
            string folder = "output";
            pptAIApi.SearchWithHttpInfo(fileName, question, language, enableHistory, null, folder);
        }
        public static void Search_EnableHistoryWithId()
        {
            string fileName = "Search_EnableHistoryWithId.txt";
            string question = "我刚刚提到了什么？";
            string language = "Chinese";
            bool enableHistory = true;
            string conversationID = GetConversationID("output/Search_EnableHistory.txt");
            string folder = "input";
            pptAIApi.SearchWithHttpInfo(fileName, question, language, enableHistory, conversationID, folder);
        }
        public static void Search_UnableHistory()
        {
            string fileName = "Search_UnableHistory.txt";
            string question = "how we can add a clickable URL to the Image as well?";
            string language = "English";
            bool enableHistory = false;
            string folder = "output";
            pptAIApi.SearchWithHttpInfo(fileName, question, language, enableHistory, null, folder);
        }
        public void Search_UnableHistoryWithId()
        {
            string fileName = "Search_UnableHistoryWithId.txt";
            string question = "我刚刚提到了什么？";
            string language = "English";
            bool enableHistory = false;
            string conversationID = GetConversationID("output/Search_EnableHistory.txt");
            string folder = "output";
            pptAIApi.SearchWithHttpInfo(fileName, question, language, enableHistory, conversationID, folder);
        }

        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}
