﻿using Spire.Cloud.Powerpoint.Sdk.Client;
using Spire.Cloud.Powerpoint.Sdk.Api;
using Newtonsoft.Json.Linq;
using System.IO;
using System;
using System.Collections.Generic;

namespace SpireCloudSDK
{
    class DocumentSearch_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration pptConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static PowerPointAIApi pptAIApi = new PowerPointAIApi(pptConfiguration_AI);

        public static void DocumentSearch()
        {
            string fileName = "sample.pptx";
            string destFilePath = "output/DocumentSearch.txt";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            string folder = "input";

            pptAIApi.DocumentSearchWithHttpInfo(fileName, destFilePath, question, null, null, null, folder);
        }
        public static void DocumentSearch_EnableHistory()
        {
            string fileName = "sample.pptx";
            string destFilePath = "output/SearchDocument_EnableHistory.txt";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            bool enableHistory = true;
            string folder = "input";

            pptAIApi.DocumentSearchWithHttpInfo(fileName, destFilePath, question, null, enableHistory, null, folder);
        }
        public static void DocumentSearch_EnableHistoryWithId()
        {
            string fileName = "sample.pptx";
            string destFilePath = "output/SearchDocument_EnableHistoryWithId.txt";
            string question = "我刚才的问题要求什么语言回答？";
            bool enableHistory = true;
            string folder = "input";
            string conversationID = GetConversationID("output/SearchDocument_EnableHistory.txt");

            pptAIApi.DocumentSearchWithHttpInfo(fileName, destFilePath, question, null, enableHistory, conversationID, folder);
        }
        public static void DocumentSearch_UnableHistory()
        {
            string fileName = "sample.pptx";
            string destFilePath = "output/SearchDocument_UnableHistory.txt";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            bool enableHistory = false;
            string folder = "input";

            pptAIApi.DocumentSearchWithHttpInfo(fileName, destFilePath, question, null, enableHistory, null, folder);
        }
        public static void DocumentSearch_UnableHistoryWithId()
        {
            string fileName = "sample.pptx";
            string destFilePath = "output/SearchDocument_UnableHistory.txt";
            string question = "我刚才问了什么问题？";
            bool enableHistory = false;
            string conversationID = GetConversationID("output/SearchDocument_EnableHistory.txt");
            string folder = "input";

            pptAIApi.DocumentSearchWithHttpInfo(fileName, destFilePath, question, null, enableHistory, conversationID, folder);
        }
        public static void DocumentSearch_Options()
        { 
            string fileName = "sample.pptx";
            string destFilePath = "output/DocumentSearch_Options.txt";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            bool enableHistory = false;
            string folder = "input";
            Dictionary<string, string> options = new Dictionary<string, string>();
            options.Add("search_type", "similarity");
            options.Add("search_kwargs", "{\"k\": 10}");
            string password =  "1234abcd";

            pptAIApi.DocumentSearchWithHttpInfo(fileName, destFilePath, question, options, enableHistory, null, folder,null, password);
        }
        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}
