﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using System;

namespace CloudPdf
{
    class PdfTextApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfTextApi PdfTextApi = new PdfTextApi(PdfConfiguration);

        public static void AddText()
        {
            string name = "AddText.pdf";
            string outPath = "output/AddText_output.pdf";
            int pageNumber = 1;
            string folder = "input";
            Text text = new Text("This is a test.",
                new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Regular),
                new RectangleF(10, 10, 100, 50));//
            text.BackgroundColor = new Color(0, 0, 0, 255);
            string password = null;
            string storage = null;
            PdfTextApi.AddText(name, outPath, pageNumber, text, folder, storage,password);

        }

        public static void AddTextWithPassword()
        {
            string name = "AddTextWithPassword.pdf";
            string outPath = "output/AddTextWithPassword_output.pdf";
            string password = "test";
            string storage = null;
            int pageNumber = 1;
            string folder = "input";
            Text text = new Text("This is a test.",
                new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Regular),
                new RectangleF(10, 10, 100, 50));
            text.BackgroundColor = new Color(0, 0, 0, 255);
            PdfTextApi.AddText(name, outPath, pageNumber, text, folder, storage, password);

        }
        public static void AddTextWithBounds()
        {
            string name = "AddTextWithBounds.pdf";
            string outPath = "output/AddTextWithBounds_output.pdf";
            int pageNumber = 1;
            string folder = "input";
            Text text = new Text("This is a test.",
                new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Italic),
                new RectangleF(10, 10, 100, 50));
            text.BackgroundColor = new Color(0, 0, 0, 255);
            text.ForegroundColor = new Color(0, 0, 255, 0);
            string password = null;
            string storage = null;
            PdfTextApi.AddText(name, outPath, pageNumber, text, folder, storage,password);
        }

        public static void AddTextWithTrueTypeFont()
        {
            string name = "AddTextWithTrueTypeFont.pdf";
            string outPath = "output/AddTextWithTrueTypeFont_output.pdf";
            int pageNumber = 1;
            string folder = "input";
            Text text = new Text("This is a test.",
                new Font(Font.FontTypeEnum.TrueType, "Arial", 12, Font.FontStyleEnum.Regular),
                new RectangleF(10, 10, 100, 50));
            text.BackgroundColor = new Color(0, 0, 0, 255);
            string password = null;
            string storage = null;
            PdfTextApi.AddText(name, outPath, pageNumber, text, folder, storage, password);
        }

        public static void AddTextWithUnicodeTrueTypeFont()
        {
            string name = "AddTextWithUnicodeTrueTypeFont.pdf";
            string outPath = "output/AddTextWithUnicodeTrueTypeFont_output.pdf";
            int pageNumber = 1;
            string folder = "input";
            Text text = new Text("This is a test.",
                new Font(Font.FontTypeEnum.UnicodeTrueType, "Arial", 12, Font.FontStyleEnum.Regular),
                new RectangleF(10, 10, 100, 50));
            text.BackgroundColor = new Color(0, 255, 0, 0);
            string password = null;
            string storage = null;
            PdfTextApi.AddText(name, outPath, pageNumber, text, folder, storage, password);
        }

        public static void AddTextWithSpaces()
        {
            string name = "AddTextWithSpaces.pdf";
            string outPath = "output/AddTextWithSpaces_output.pdf";
            int pageNumber = 1;
            string folder = "input";
            Text text = new Text("This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!",
                new Font(Font.FontTypeEnum.Standard, "Helvetica", 9, Font.FontStyleEnum.Regular),
                new RectangleF(10, 10, 100, 200));
            text.BackgroundColor = new Color(0, 0, 0, 255);
            text.CharSpacing = 20;
            text.FirstLineIndent = 20;
            text.HorizontalAlignment = Text.HorizontalAlignmentEnum.Left;
            text.LineSpacing = 20;
            text.VerticalAlignment = Text.VerticalAlignmentEnum.Bottom;
            text.WordSpacing = 20;
            string password = null;
            string storage = null;
            PdfTextApi.AddText(name, outPath, pageNumber, text, folder, storage, password);
        }

        public static void AddTextWithWordWrapWord()
        {
            string name = "AddTextWithWordWrapWord.pdf";
            string outPath = "output/AddTextWithWordWrapWord_output.pdf";
            int pageNumber = 1;
            string folder = "input";
            Text text = new Text("This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!This is a test!",
                new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
                new RectangleF(10, 10, 100, 50));
            text.BackgroundColor = new Color(0, 0, 0, 255);
            text.CharSpacing = 20;
            text.WordWrap = Text.WordWrapEnum.Word;
            string password = null;
            string storage = null;
            PdfTextApi.AddText(name, outPath, pageNumber, text, folder, storage, password);
        }

        public static void ExtractText()
        {
            string name = "ExtractText.pdf";
            string outPath = "output/ExtractText_output.txt";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            PdfTextApi.ExtractText(name, outPath, pageNumber, folder, storage, password);
        }
    }
}
