﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using System;
using System.Collections.Generic;
using System.IO;

namespace CloudPdf
{
    class PdfSecurityApiDemo
    {

        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfSecurityApi PdfSecurityApi = new PdfSecurityApi(PdfConfiguration);
        public static void DecryptDocumentInRequest()
        {
            using (System.IO.Stream file = new FileStream("DecryptDocumentInRequest.pdf", FileMode.Open))
            {
                string password = "123";
                var response = PdfSecurityApi.DecryptDocumentInRequest(file, password);
            }
        }
        public static void DecryptDocumentInStorage()
        {
            string name = "DecryptDocumentInStorage.pdf";
            string outPath = "output/DecryptDocumentInStorage_output.pdf";
            string password = "123";
            string storage = null;
            string folder = "input";
            PdfSecurityApi.DecryptDocumentInStorage(name, outPath, password, folder,storage);
        }

        public static void EncryptDocumentInRequest()
        {
            using (System.IO.Stream file = new FileStream("EncryptDocumentInRequest.pdf", FileMode.Open))
            {
                string userPassword = "e123";
                string ownerPassword = "e321";
                string keySize = "Key40Bit";//supports "Key40Bit"/"Key128Bit"/"Key256Bit"
                List<string> permissionsFlags = new List<string>();
                permissionsFlags.Add("Print");
                permissionsFlags.Add("EditContent");
                string password = "123";
                var response = PdfSecurityApi.EncryptDocumentInRequest(file, userPassword, ownerPassword, keySize, permissionsFlags, password);
            }
        }
        public static void EncryptDocumentInStorage()
        {
            string name = "EncryptDocumentInStorage.pdf";
            string outPath = "output/EncryptDocumentInStorage_output.pdf";
            string userPassword = "123";
            string ownerPassword = "321";
            string keySize = "Key40Bit";//supports "Key40Bit"/"Key128Bit"/"Key256Bit"
            List<string> permissionsFlags = new List<string>();
            permissionsFlags.Add("Print");
            permissionsFlags.Add("EditContent");
            string password = "123";
            string folder = "input";
            PdfSecurityApi.EncryptDocumentInStorage(name, outPath, userPassword, ownerPassword, keySize, permissionsFlags, folder, password);
        }
    }
}
