﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using System;
using System.IO;

namespace CloudPdf
{
    class PdfConvertApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration pdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfConvertApi pdfConvertApi = new PdfConvertApi(pdfConfiguration);
        public static void PdfConvertDoc()
        {
            string name = "Sample.pdf";
            string password = null;
            string storage = null;
            string format = "Doc"; //Supported formats: Doc/Docx/Html/Pcl/Ps/Svg/Xps
            string dstpath = "output/PdfConvertDoc.doc";
            string folder = "input";
            pdfConvertApi.Convert(name, dstpath, format, folder, storage, password);
        }

        public static void XpsConvertDoc()
        {
            string name = "Sample.xps";
            string password = null;
            string storage = null;
            string format = "Doc"; //Supported formats: Doc/Docx/Html/Pcl/Ps/Svg/Pdf
            string dstpath = "output/XpsConvertDoc.doc";
            string folder = "input";
            pdfConvertApi.Convert(name, dstpath, format, folder, storage, password);
        }

        public static void PdfConvertInRequestDoc()
        {
            Stream file = new FileStream("D:/inputFile/Sample.pdf", FileMode.Open);
            string password = null;
            string format = "Doc"; //Supported formats: Doc/Docx/Html/Pcl/Ps/Svg/Xps/Txt/Markdown
            var response = pdfConvertApi.ConvertInRequest(file, format, password);  
        }

        public static void XpsConvertInRequestDoc()
        {
            Stream file = new FileStream("D:/inputFile/Sample.pdf", FileMode.Open);
            string password = null;
            string format = "Doc"; //Supported formats: Doc/Docx/Html/Pcl/Ps/Svg/Pdf/Png
            var response = pdfConvertApi.ConvertInRequest(file, format, password);
        }

        public static void ConvertInRequestToPng()
        {
            using (Stream file = new FileStream("D;/inputFile/Sample.pdf", FileMode.Open))
            {
                int? dx = null;
                int? dy = null;
                string password = null;
                pdfConvertApi.ConvertInRequestToPng(file, dx, dy, password);                
            }
        }

        public static void ConvertToPng()
        {
            int? dx = null;
            int? dy = null;
            string name = "Sample.pdf";
            string password = null;
            string storage = null;
            string dstpath = "output/ConvertToPng/";
            string folder = "input";
            pdfConvertApi.ConvertToPng(name, dstpath, dx, dy, folder, storage, password);
        }
    }
}
