﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using System;

namespace CloudPdf
{
    class PdfBookmarksApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfBookmarksApi pdfBookmarkApi = new PdfBookmarksApi(PdfConfiguration);
        public static void AddBookmark()
        {
            string name = "AddBookmark.pdf";
            string outPath = "output/AddBookmark.pdf";
            string bookmarkPath = "1";
            Bookmark bookmark = new Bookmark();
            bookmark.Title = "testTitle";
            bookmark.Color = new Color(0, 255, 0, 0);
            bookmark.PageNumber = 1;
            bookmark.Bold = true;
            bookmark.Italic = true;
            bookmark.PageDisplay = Bookmark.PageDisplayEnum.XYZ;
            bookmark.PageDisplayLeft = 10;
            bookmark.PageDisplayTop = 20;
            string folder = "input";
            string password = null;
            string storage = null;
            pdfBookmarkApi.AddBookmark(name, outPath, bookmarkPath, bookmark, folder, storage, password);
        }

        public static void AddBookmarkWithGoToAction()
        {
            string name = "AddBookmarkWithGoToAction.pdf";
            string outPath = "output/AddBookmarkWithGoToAction.pdf";
            string bookmarkPath = "1";
            Bookmark bookmark = new Bookmark();
            bookmark.Title = "testTitle";
            bookmark.Color = new Color(0, 255, 0, 0);
            bookmark.Bold = true;
            bookmark.Italic = true;
            bookmark.Action = Bookmark.ActionEnum.GoTo;
            bookmark.PageDisplay = Bookmark.PageDisplayEnum.XYZ;
            bookmark.PageNumber = 1;
            bookmark.PageDisplayLeft = 10;
            bookmark.PageDisplayTop = 20;
            string folder = "input";
            string password = null;
            string storage = null;
            pdfBookmarkApi.AddBookmark(name, outPath, bookmarkPath, bookmark, folder, storage, password);
        }

        public static void DeleteBookmark()
        {
            string name = "DeleteBookmark.pdf";
            string outPath = "output/DeleteBookmark.pdf";
            string bookmarkPath = "1";
            string folder = "input";
            string storage = null;
            string password = null;
            pdfBookmarkApi.DeleteBookmark(name, outPath, bookmarkPath, folder, storage, password);
        }
        public static void DeleteChildBookmark()
        {
            string name = "DeleteChildBookmark.pdf";
            string outPath = "output/DeleteChildBookmark.pdf";
            string bookmarkPath = "1-2";
            string folder = "input";
            string storage = null;
            string password = null;
            pdfBookmarkApi.DeleteBookmark(name, outPath, bookmarkPath, folder, storage, password);
        }

        public static void DeleteBookmarks()
        {
            string name = "DeleteBookmarks.pdf";
            string outPath = "output/DeleteAllBookmarks_output.pdf";
            string folder = "input";
            string storage = null;
            string password = null;
            pdfBookmarkApi.DeleteBookmarks(name, outPath, folder, storage, password);
        }

        public static void GetBookmarkInfo()
        {
            string name = "GetBookmarkInfo.pdf";
            string bookmarkPath = "1-2";
            string folder = "input";
            string storage = null;
            string password = null;
            var response = pdfBookmarkApi.GetBookmarkInfo(name, bookmarkPath, folder, storage, password);
        }

        public static void GetBookmarksInfo()
        {
            string name = "GetBookmarksInfo.pdf";
            string folder = "input";
            string storage = null;
            string password = null;
            var response = pdfBookmarkApi.GetBookmarksInfo(name, folder, storage, password);
        }

        public static void UpdateBookmark()
        {
            string name = "UpdateBookmark.pdf";
            string outPath = "output/UpdateBookmark.pdf";
            string bookmarkPath = "1-1";
            Bookmark bookmark = new Bookmark();
            bookmark.PageNumber = 1;
            bookmark.Title = "updateTitile";
            bookmark.Color = new Color(0, 255, 0, 0);
            bookmark.Bold = false;
            bookmark.Italic = false;
            bookmark.PageDisplay = Bookmark.PageDisplayEnum.XYZ;
            bookmark.PageDisplayLeft = 10;
            bookmark.PageDisplayTop = 20;
            string folder = "input";
            string storage = null;
            string password = null;
            pdfBookmarkApi.UpdateBookmark(name, outPath, bookmarkPath, bookmark, folder, storage, password);
        }

    }
}
