﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;

namespace CloudPdf
{
    class PdfBarcodeApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfBarcodeApi pdfBarcodeApi = new PdfBarcodeApi(PdfConfiguration);

        public static void AddBarcode()
        {            
            string name = "AddBarcode.pdf";
            string outPath = "output/AddBarcode.pdf";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            List<Barcode> list = new List<Barcode>();
            Font font = new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold);
            list.Add(new Barcode(50, 50, 50, 50, Barcode.TypeEnum.Codabar, "123456789", font, 1, true, true, Barcode.TextDisplayLocationEnum.Bottom));
            list.Add(new Barcode(50, 150, 50, 50, Barcode.TypeEnum.Code11, "123-4567890", null, 1, true, true, Barcode.TextDisplayLocationEnum.Top));
            list.Add(new Barcode(50, 250, 50, 50, Barcode.TypeEnum.Code128A, "HELLO 00-123", null, 1, true, true, Barcode.TextDisplayLocationEnum.None));
            list.Add(new Barcode(50, 350, 50, 50, Barcode.TypeEnum.Code128B, "Hello 00-123", null));
            list.Add(new Barcode(50, 450, 50, 50, Barcode.TypeEnum.Code128C, "00253645", null));
            list.Add(new Barcode(300, 50, 50, 50, Barcode.TypeEnum.Code32, "16273849", null, 0, true, true, Barcode.TextDisplayLocationEnum.Top));
            list.Add(new Barcode(300, 150, 50, 50, Barcode.TypeEnum.Code39, "16-273849", null, 0, false, false, Barcode.TextDisplayLocationEnum.Top));
            list.Add(new Barcode(300, 250, 50, 50, Barcode.TypeEnum.Code39Extended, "16-273849", null, 0, true, true, Barcode.TextDisplayLocationEnum.None));
            list.Add(new Barcode(300, 350, 50, 50, Barcode.TypeEnum.Code93, "16-273849", null, 0, true, false, Barcode.TextDisplayLocationEnum.Bottom));
            list.Add(new Barcode(300, 450, 50, 50, Barcode.TypeEnum.Code93Extended, "16-273849", null, 0, false, true, Barcode.TextDisplayLocationEnum.Top));
            pdfBarcodeApi.AddBarcode(name, outPath, pageNumber, list, folder, storage, password);
        }

        public static void ConvertToPng()
        {
            string outPath = "output/Codabar.png";
            Font font = new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold);
            //Supported barcode types: Codabar/Code11/Code128A/Code128B/Code128C/Code32/Code39/Code39Extended/Code93/Code93Extended
            Barcode barcode = new Barcode(50, 50, null, null, Barcode.TypeEnum.Codabar, "123456789", font, 1, true, true, Barcode.TextDisplayLocationEnum.Bottom);
            string storage=null;
            pdfBarcodeApi.GeneratePng(barcode, outPath,storage);
        }
    }
}
