﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Spire.Cloud.Pdf.Sdk.Api;
using System.IO;
using System.Reflection;
using Spire.Cloud.Pdf.Sdk.Model;
using Spire.Cloud.Pdf.Sdk.Client;

namespace CloudPdf
{
    class PdfAttachmentsApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfAttachmentsApi pdfAttachmentsApi = new PdfAttachmentsApi(PdfConfiguration);
        public static void AddAttachment()
        {
            string name = "AddAttachment.pdf";
            string outPath = "output/AddAttachment_output.pdf";

            using (System.IO.Stream file = new FileStream("AddAttachment.jpg", FileMode.Open))
            {
                string attachmentFileName = "AddAttachment.jpg";
                string description = null;
                string folder = "input";
                string storage = null;
                string password = null;
                pdfAttachmentsApi.AddAttachment(name, outPath, file, attachmentFileName, description, folder, storage, password);
            }
        }

        public static void AddAttachmentWithDescription()
        {            
            string name = "AddAttachmentWithDescription.pdf";
            string outPath = "output/AddAttachmentWithDescription_output.pdf";

            using (System.IO.Stream file = new FileStream("AddAttachmentWithDescription.jpg", FileMode.Open))
            {
                string attachmentFileName = "AddAttachmentWithDescription.jpg";
                string description = "description";
                string folder = "input";
                string storage = null;
                string password = null;
                pdfAttachmentsApi.AddAttachment(name, outPath, file, attachmentFileName, description, folder, storage, password);
            }
        }

        public static void DownloadAttachment()
        {          
            string name = "DownloadAttachment.pdf";
            int orderNumber = 1;
            string folder = "input";
            string storage = null;
            string password = null;
            var response = pdfAttachmentsApi.DownloadAttachment(name, orderNumber, folder, storage, password);
        }

        public static void GetAttachmentsInfo()
        {
            string name = "GetAttachmentsInfo.pdf";
            string folder = "input";
            string storage = null;
            string password = null;
            var response = pdfAttachmentsApi.GetAttachmentsInfo(name, folder, storage, password);
        }
    }
}
