﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;

namespace CloudPdf
{
    class PdfAnnotationApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfAnnotationApi pdfAnnotationApi = new PdfAnnotationApi(PdfConfiguration);
        public static void AddFileAttachmentAnnotation()
        {
            string name = "Sample.pdf";
            string outPath = "output/AddFileAttachmentAnnotation.pdf";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            List<FileAttachmentAnnotation> lists = new List<FileAttachmentAnnotation>();
            FileAttachmentAnnotation annotation1 = new FileAttachmentAnnotation(
                new Color(100, 255, 0, 0), "File attachment annotation test 1",
                 null, null, "FileAttachmentAnnotation1",
                new RectangleF(50, 50, 50, 50), null, null, null, "Sample.xps");

            FileAttachmentAnnotation annotation2 = new FileAttachmentAnnotation(
                new Color(100, 0, 0, 255), "File attachment annotation test 2",
                 null, null, "FileAttachmentAnnotation2",
                new RectangleF(50, 150, 50, 50), null, null, null, "Sample.txt");

            FileAttachmentAnnotation annotation3 = new FileAttachmentAnnotation(
                new Color(1, 255, 182, 193), "File attachment annotation test 3",
                 null, null, "FileAttachmentAnnotation3",
                new RectangleF(50, 250, 50, 50), null, null, null, "Image.pdf");

            FileAttachmentAnnotation annotation4 = new FileAttachmentAnnotation(
                new Color(1, 238, 130, 238), "File attachment annotation test 4",
               null, null, "FileAttachmentAnnotation2",
                new RectangleF(50, 350, 50, 50), null, null, null, "Attachment.jpg");

            lists.Add(annotation1);
            lists.Add(annotation2);
            lists.Add(annotation3);
            lists.Add(annotation4);
            FileAttachmentAnnotations fileAttachmentAnnotations = new FileAttachmentAnnotations(lists);
            pdfAnnotationApi.AddFileAttachmentAnnotation(name, outPath, pageNumber, fileAttachmentAnnotations, folder, storage, password);
        }

        public static void AddFreeTextAnnotations()
        {
            string name = "Sample.pdf";
            string outPath = "output//AddFreeTextAnnotation.pdf";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            AnnotationBorder border1 = new AnnotationBorder(0.5f, 0, 0);
            AnnotationBorder border2 = new AnnotationBorder(5, 2, 2);
            List<PointF> calloutLines = new List<PointF>();
            calloutLines.Add(new PointF(150, 50));
            calloutLines.Add(new PointF(155, 45));
            calloutLines.Add(new PointF(160, 40));
            List<float?> rectangleDifferences = new List<float?>() { 20, 20, 5, 5 };
            FreeTextAnnotation annotation1 = new FreeTextAnnotation(
                new Color(255, 225, 225, 255), "Free text annotation test 1", null, FreeTextAnnotation.FlagsEnum.Invisible,
                "FreeTextAnnotation1", new RectangleF(160, 40, 40, 12), 1, border1,
                "E-iceblue", new Font(Font.FontTypeEnum.Standard, "Helvetica", 8, Font.FontStyleEnum.Italic),
                new Color(1, 65, 105, 225), new Color(255, 0, 0, 0), null, null, 0.7f,
                calloutLines, null);

            FreeTextAnnotation annotation2 = new FreeTextAnnotation(
                new Color(255, 245, 222, 179), "Free text annotation test 2", null, FreeTextAnnotation.FlagsEnum.Invisible,
                "FreeTextAnnotation2", new RectangleF(50, 50, 100, 100), 1, border2,
                "E-iceblue", new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
                new Color(100, 0, 255, 0), new Color(255, 0, 0, 0), LineEnding.Slash,
                FreeTextAnnotation.IntentEnum.FreeTextTypeWriter, 1, null, rectangleDifferences);


            List<FreeTextAnnotation> lists = new List<FreeTextAnnotation>();
            lists.Add(annotation1);
            lists.Add(annotation2);
            FreeTextAnnotations freeTextAnnotations = new FreeTextAnnotations(lists);
            pdfAnnotationApi.AddFreeTextAnnotation(name, outPath, pageNumber, freeTextAnnotations, folder, storage, password);
        }

        public static void AddLineAnnotation()
        {
            string name = "Sample.pdf";
            string outPath = "output/AddLineAnnotation.pdf";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            List<LineAnnotation> lists = new List<LineAnnotation>();
            LineAnnotation annotation1 = new LineAnnotation(
                new Color(100, 255, 0, 0), "line annotation test 1",
                null, null, "LineAnnotation1", new RectangleF(50, 50, 500, 50),
                null, new PointF(60, 60), new PointF(500, 60), null,
                null, 0, 0, null, null, null, null, null, null);

            LineAnnotation annotation2 = new LineAnnotation(
                new Color(100, 0, 0, 255), "line annotation test 2",
                null, null, "LineAnnotation2", new RectangleF(50, 350, 500, 50),
                null, new PointF(60, 360), new PointF(500, 360), null,
                null, 0, 0, null, null, null, null, null, null);

            lists.Add(annotation1);
            lists.Add(annotation2);
            LineAnnotations lineAnnotations = new LineAnnotations(lists);
            pdfAnnotationApi.AddLineAnnotation(name, outPath, pageNumber, lineAnnotations, folder, storage, password);
        }

        public static void AddLinkAnnotation()
        {           
            string name = "Sample.pdf";
            string outPath = "output/AddLinkAnnotation.pdf";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            Destination dest1 = new Destination(1, 1, Destination.ModeEnum.FitToPage, null, new RectangleF(50, 50, 500, 500));
            List<LinkAnnotation> lists = new List<LinkAnnotation>();
            LinkAnnotation annotation1 = new LinkAnnotation(
                new Color(100, 255, 0, 0), "Link annotation test 1",
                null, LinkAnnotation.FlagsEnum.Default, "LinkAnnotation1", new RectangleF(50, 50, 50, 50),
                null, null, LinkAnnotation.HighlightModeEnum.Invert, LinkAnnotation.ActionTypeEnum.GoToAction,
                new GoToAction(dest1), null, null, null, null, null, null);

            Destination dest2 = new Destination(2, 2, Destination.ModeEnum.FitToPage, null, new RectangleF(50, 50, 500, 500));
            LinkAnnotation annotation2 = new LinkAnnotation(
               new Color(100, 0, 0, 255), "Link annotation test 2",
               null, LinkAnnotation.FlagsEnum.Default, "LinkAnnotation2", new RectangleF(50, 150, 50, 50),
               null, null, LinkAnnotation.HighlightModeEnum.Outline, LinkAnnotation.ActionTypeEnum.GoToAction,
               new GoToAction(dest2), null, null, null, null, null, null);

            LaunchAction launchAction = new LaunchAction("/input/Image.pdf", true);
            LinkAnnotation annotation3 = new LinkAnnotation(
               new Color(100, 0, 255, 0), "Link annotation test 3 LaunchAction",
               null, LinkAnnotation.FlagsEnum.Default, "LinkAnnotation3", new RectangleF(50, 300, 50, 50),
               null, null, LinkAnnotation.HighlightModeEnum.Invert, LinkAnnotation.ActionTypeEnum.LaunchAction,
               null, null, null, launchAction, null, null, null);

            URIAction uriAction = new URIAction("https://www.baidu.com");
            LinkAnnotation annotation4 = new LinkAnnotation(
               new Color(100, 0, 255, 0), "Link annotation test 4 URIAction",
               null, LinkAnnotation.FlagsEnum.Default, "LinkAnnotation4", new RectangleF(300, 50, 50, 50),
               null, null, LinkAnnotation.HighlightModeEnum.Invert, LinkAnnotation.ActionTypeEnum.URIAction,
               null, null, null, null, null, null, uriAction);

            NamedAction namedAction = new NamedAction(NamedAction.NameEnum.NextPage);
            LinkAnnotation annotation5 = new LinkAnnotation(
               new Color(100, 0, 255, 0), "Link annotation test 5 NamedAction",
               null, LinkAnnotation.FlagsEnum.Default, "LinkAnnotation5", new RectangleF(300, 150, 50, 50),
               null, null, LinkAnnotation.HighlightModeEnum.Invert, LinkAnnotation.ActionTypeEnum.NamedAction,
               null, null, null, null, namedAction, null, null);

            EmbeddedGoToAction action = new EmbeddedGoToAction(dest2, "/input/Annotation.pdf", true);
            LinkAnnotation annotation6 = new LinkAnnotation(
               new Color(100, 0, 255, 0), "Link annotation test 6 EmbeddedGoToAction",
               null, LinkAnnotation.FlagsEnum.Default, "LinkAnnotation6", new RectangleF(300, 300, 50, 50),
               null, null, LinkAnnotation.HighlightModeEnum.Invert, LinkAnnotation.ActionTypeEnum.EmbeddedGoToAction,
               null, action, null, null, null, null, null);

            lists.Add(annotation1);
            lists.Add(annotation2);
            lists.Add(annotation3);
            lists.Add(annotation4);
            lists.Add(annotation5);
            lists.Add(annotation6);
            LinkAnnotations linkAnnotations = new LinkAnnotations(lists);
            pdfAnnotationApi.AddLinkAnnotation(name, outPath, pageNumber, linkAnnotations, folder, storage, password);
        }

        public static void AddPopupAnnotation()
        {  
            string name = "Sample.pdf";
            string outPath = "output/AddPopupAnnotation.pdf";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            AnnotationApperanceText text = new AnnotationApperanceText("This is a test! ",
               new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
               new RectangleF(10, 10, 80, 20), null, new Color(255, 0, 0, 0));
            AnnotationApperanceImage image = new AnnotationApperanceImage(new PointF(50, 50), "Attachment.jpg");
            AnnotationApperance apperance = new AnnotationApperance(100, 100, text, image);

            List<PopupAnnotation> lists = new List<PopupAnnotation>();
            PopupAnnotation annotation1 = new PopupAnnotation(
                new Color(100, 255, 0, 0), "Popup annotation test 1",
                 null, null, "PopupAnnotation1",
                new RectangleF(50, 50, 100, 100),
                1, null, null, null);

            PopupAnnotation annotation2 = new PopupAnnotation(
                new Color(100, 0, 0, 255), "Popup annotation test 2",
                 null, null, "PopupAnnotation2",
                new RectangleF(50, 350, 500, 50),
                1, null, null, null, apperance, null, null);

            lists.Add(annotation1);
            lists.Add(annotation2);
            PopupAnnotations popupAnnotations = new PopupAnnotations(lists);
            pdfAnnotationApi.AddPopupAnnotation(name, outPath, pageNumber, popupAnnotations, folder, storage, password);
        }

        public static void AddRubberStampAnnotation()
        {
            string name = "Sample.pdf";
            string outPath = "output/AddRubberStampAnnotation.pdf";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            AnnotationApperanceText text1 = new AnnotationApperanceText("Test Normal! ",
               new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
               new RectangleF(10, 10, 80, 20), null, new Color(255, 0, 0, 0));
            AnnotationApperanceText text2 = new AnnotationApperanceText("Test MouseHover! ",
               new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
               new RectangleF(10, 10, 80, 20), null, new Color(255, 0, 0, 0));
            AnnotationApperanceText text3 = new AnnotationApperanceText("Test Pressed! ",
              new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
              new RectangleF(10, 10, 80, 20), null, new Color(255, 0, 0, 0));
            AnnotationApperanceImage image = new AnnotationApperanceImage(new PointF(50, 50), "Attachment.jpg");
            AnnotationApperance apperance1 = new AnnotationApperance(100, 100, text1, image);
            AnnotationApperance apperance2 = new AnnotationApperance(100, 100, text2, image);
            AnnotationApperance apperance3 = new AnnotationApperance(100, 100, text3, image);

            List<RubberStampAnnotation> lists = new List<RubberStampAnnotation>();
            RubberStampAnnotation annotation1 = new RubberStampAnnotation(
                new Color(100, 255, 0, 0), "Rubber stamp annotation test 1",
                 null, null, "RubberStampAnnotation1",
                new RectangleF(50, 50, 80, 80), 1, null, "RubberStamp1", null, null);

            RubberStampAnnotation annotation2 = new RubberStampAnnotation(
                new Color(100, 0, 0, 255), "Rubber stamp annotation test 2",
                 null, null, "RubberStampAnnotation2",
                new RectangleF(50, 350, 100, 100), 1, null, "RubberStamp2",
                RubberStampAnnotation.IconEnum.Additional, apperance1, apperance2, apperance3);

            lists.Add(annotation1);
            lists.Add(annotation2);
            RubberStampAnnotations rubberStampAnnotations = new RubberStampAnnotations(lists);
            pdfAnnotationApi.AddRubberStampAnnotation(name, outPath, pageNumber, rubberStampAnnotations, folder, storage, password);
        }

        public static void DeletePageAnnotations()
        {
            string name = "AnnotationSample.pdf";
            int pageNumber = 1;
            string outPath = "output/DeletePageAnnotation.pdf";
            string password = null;
            string folder = "input";
            pdfAnnotationApi.DeletePageAnnotations(name, outPath, pageNumber, folder, password);
        }

        public static void DeleteAnnotationsByID()
        {
            string name = "Annotation.pdf";
            string outPath = "output/DeleteAnnotationsByID.pdf";
            List<string> ids = new List<string>();
            ids.Add("1-1");
            ids.Add("1-2");
            ids.Add("1-3");
            string password = null;
            string storage = null;
            string folder = "input";
            pdfAnnotationApi.DeleteAnnotationsByID(name, outPath, ids, folder, storage, password);
        }

        public static void GetPageAnnotation()
        {
            string name = "Annotation_1.pdf";
            int pageNumber = 1;
            string password = null;
            string storage = null;
            string folder = "input";
            Annotations response = pdfAnnotationApi.GetPageAnnotation(name, pageNumber, folder, storage, password);
        }

        public static void ReplaceFileAttachmentAnnotationByID()
        {
            string name = "ReplaceFileAttachmentAnnotationByID.pdf";
            string outPath = "output/ReplaceFileAttachmentAnnotationByID.pdf";
            string id = "1-1";

            FileAttachmentAnnotation annotation = new FileAttachmentAnnotation(
                new Color(100, 0, 255, 0), "File attachment annotation test replace",
                 null, null, "ReplaceLineAnnotation",
                new RectangleF(50, 50, 50, 50), null, null, null, "Sample.txt");

            string password = null;
            string storage = null;
            string folder = "input";
            pdfAnnotationApi.ReplaceFileAttachmentAnnotationByID(name, outPath, id, annotation, folder, storage, password);
        }

        public static void ReplaceFreeTextAnnotationByID()
        {
            string name = "ReplaceFreeTextAnnotationByID.pdf";
            string outPath = "output/ReplaceFreeTextAnnotationByID.pdf";
            string id = "1-2";

            FreeTextAnnotation annotation = new FreeTextAnnotation(
                 new Color(100, 0, 255, 0), "Replace free text annotation test",
                 null, null, "ReplaceFreeTextAnnotation",
                 new RectangleF(160, 40, 40, 12), 1, null, "iceblue",
                 new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
                 new Color(100, 0, 255, 255), null, null, null, 1, null, null);

            string password = null;
            string storage = null;
            string folder = "input";
            pdfAnnotationApi.ReplaceFreeTextAnnotationByID(name, outPath, id, annotation, folder, storage, password);
        }

        public static void ReplaceLineAnnotationByID()
        {
            string name = "ReplaceLineAnnotationByID.pdf";
            string outPath = "output/ReplaceLineAnnotationByID.pdf";
            string id = "1-3";

            LineAnnotation annotation = new LineAnnotation(
               new Color(255, 255, 182, 193), "line annotation test replace",
               null, null, "LineAnnotation", new RectangleF(50, 350, 500, 50),
               null, new PointF(60, 360), new PointF(500, 360), null,
               null, 0, 0, null, null, null, null, null, null);

            string password = null;
            string storage = null;
            string folder = "input";
            pdfAnnotationApi.ReplaceLineAnnotationByID(name, outPath, id, annotation, folder, storage, password);
        }

        public static void ReplaceLinkAnnotationByID()
        {
            string name = "ReplaceLinkAnnotationByID.pdf";
            string outPath = "output/ReplaceLinkAnnotationByID.pdf";
            string id = "1-4";

            Destination dest = new Destination(1, 1.5f, Destination.ModeEnum.FitToPage, null, new RectangleF(50, 50, 500, 500));
            LinkAnnotation annotation = new LinkAnnotation(
               new Color(100, 0, 255, 0), "link annotation test replace",
               null, null, "ReplaceLinkAnnotation", new RectangleF(100, 350, 50, 50),
               null, null, LinkAnnotation.HighlightModeEnum.NoHighlighting, LinkAnnotation.ActionTypeEnum.GoToAction,
               new GoToAction(dest), null, null, null, null, null, null);

            string password = null;
            string storage = null;
            string folder = "input";
            pdfAnnotationApi.ReplaceLinkAnnotationByID(name, outPath, id, annotation, folder, storage, password);
        }

        public static void ReplacePopupAnnotationByID()
        {
            string name = "ReplacePopupAnnotationByID.pdf";
            string outPath = "output/ReplacePopupAnnotationByID.pdf";
            string id = "1-4";

            AnnotationApperanceText text = new AnnotationApperanceText("This is a test! ",
                 new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
                 new RectangleF(10, 10, 80, 20), null, new Color(255, 0, 0, 0));
            AnnotationApperanceImage image = new AnnotationApperanceImage(new PointF(50, 50), "Wikipedia_Science.png");
            AnnotationApperance apperance = new AnnotationApperance(100, 100, text, image);

            PopupAnnotation annotation = new PopupAnnotation(
                new Color(100, 0, 255, 0), "Replace popup annotation test",
                 null, null, "ReplacePopupAnnotation",
                new RectangleF(100, 350, 500, 50),
                1, null, null, null, apperance);

            string password = null;
            string storage = null;
            string folder = "input";
            pdfAnnotationApi.ReplacePopupAnnotationByID(name, outPath, id, annotation, folder, storage, password);
        }

        public static void ReplaceRubberStampAnnotationByID()
        {
            string name = "ReplaceRubberStampAnnotationByID.pdf";
            string outPath = "output/ReplaceRubberStampAnnotationByID.pdf";
            string id = "1-5";

            AnnotationApperanceText text = new AnnotationApperanceText("Test Normal! ",
              new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Bold),
              new RectangleF(10, 10, 80, 20), null, new Color(255, 0, 0, 0));
            AnnotationApperanceImage image = new AnnotationApperanceImage(new PointF(50, 50), "Wikipedia_Science.png");
            AnnotationApperance apperance = new AnnotationApperance(100, 100, text, image);

            RubberStampAnnotation annotation = new RubberStampAnnotation(
                new Color(100, 0, 255, 0), "Replace rubber stamp annotation test",
                 null, null, "ReplaceRubberStampAnnotation",
                new RectangleF(50, 200, 100, 100), 1, null, "ReplaceRubberStamp", RubberStampAnnotation.IconEnum.Draft, apperance);

            string password = null;
            string storage = null;
            string folder = "input";
            pdfAnnotationApi.ReplaceRubberStampAnnotationByID(name, outPath, id, annotation, folder, storage, password);
        }
    }
}
