﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using Spire.Cloud.Pdf.Sdk.Test;
using Spire.Cloud.Pdf.Sdk.Test.TestHelper;
using System;
using System.Collections.Generic;

namespace CloudPdf
{
    class PdfAcroFormApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfAcroFormApi pdfAcroFormApi = new PdfAcroFormApi(PdfConfiguration);
        public static void AddCheckBoxField()
        {           
            CheckBoxHelper helper = null;
            CheckBoxField checkBoxField = null;
            string password = null;
            string outPath = "";
            string storage = null;

            string folder = "input";
            string name = "Sample.pdf";

            foreach (string type in Enum.GetNames(typeof(CheckBoxHelper.CheckBoxFieldTestType)))
            {
                helper = new CheckBoxHelper();

                CheckBoxHelper.CheckBoxFieldTestType type1 = (CheckBoxHelper.CheckBoxFieldTestType)Enum.Parse(typeof(CheckBoxHelper.CheckBoxFieldTestType), type);
                checkBoxField = helper.GetCheckBoxField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.AddCheckBoxField(name, outPath, checkBoxField, folder, storage, password);
            }
        }

        public static void AddComboBoxField()
        {
            ComboBoxHelper helper = null;
            string name = "Sample.pdf";
            string outPath = "";
            ComboBoxField comboBoxField = null;
            string password = null;
            string folder = "input";
            string storage = null;

            foreach (string type in Enum.GetNames(typeof(ComboBoxHelper.ComboBoxFieldTestType)))
            {
                helper = new ComboBoxHelper();
                ComboBoxHelper.ComboBoxFieldTestType type1 = (ComboBoxHelper.ComboBoxFieldTestType)Enum.Parse(typeof(ComboBoxHelper.ComboBoxFieldTestType), type);
                comboBoxField = helper.GetComboBoxField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.AddComboBoxField(name, outPath, comboBoxField, folder, storage, password);
            }
        }

        public static void AddField()
        {
            FieldHelper helper = null;
            Field field = null;
            string password = null;
            string outPath = "";
            string folder = "input";
            string name = "field.pdf";
            string storage = null;

            foreach (string type in Enum.GetNames(typeof(FieldHelper.FieldTestType)))
            {
                foreach (string fieldType in Enum.GetNames(typeof(Field.TypeEnum)))
                {
                    helper = new FieldHelper();
                    helper.f_type = (Field.TypeEnum)Enum.Parse(typeof(Field.TypeEnum), fieldType, true);
                    FieldHelper.FieldTestType type1 = (FieldHelper.FieldTestType)Enum.Parse(typeof(FieldHelper.FieldTestType), type);
                    outPath = "output/" + type1 + ".pdf";
                    field = helper.GetField(type1);
                    pdfAcroFormApi.AddField(name, outPath, field ,folder, storage,password);
                }
            }
        }

        public static void AddListBoxField()
        {
            ListBoxHelper helper = null;
            ListBoxField listBoxField = null;
            string password = null;
            string outPath = "";
            string storage = null;

            string folder = "input";
            string name = "Sample.pdf";

            foreach (string type in Enum.GetNames(typeof(ListBoxHelper.ListBoxFieldTestType)))
            {
                helper = new ListBoxHelper();

                ListBoxHelper.ListBoxFieldTestType type1 = (ListBoxHelper.ListBoxFieldTestType)Enum.Parse(typeof(ListBoxHelper.ListBoxFieldTestType), type);
                listBoxField = helper.GetListBoxField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.AddListBoxField(name, outPath, listBoxField, folder, storage, password);
            }
        }

        public static void AddPushButtonField()
        {
            PushButtonHelper helper = null;
            PushButtonField pushButtonField = null;
            string password = null;
            string outPath = "";
            string storage = null;

            string folder = "input";
            string name = "Sample.pdf";
            foreach (string type in Enum.GetNames(typeof(PushButtonHelper.PushButtonFieldTestType)))
            {
                helper = new PushButtonHelper();

                PushButtonHelper.PushButtonFieldTestType type1 = (PushButtonHelper.PushButtonFieldTestType)Enum.Parse(typeof(PushButtonHelper.PushButtonFieldTestType), type);
                pushButtonField = helper.GetPushButtonField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.AddPushButtonField(name, outPath, pushButtonField, folder, storage, password);
            }
        }

        public static void AddRadioButtonField()
        {
            RadioButtonHelper helper = null;
            RadioButtonField radioButtonField = null;
            string password = null;
            string outPath = "";
            string storage = null;

            string folder = "input";
            string name = "Sample.pdf";

            foreach (string type in Enum.GetNames(typeof(RadioButtonHelper.RadioButtonFieldTestType)))
            {
                helper = new RadioButtonHelper();

                RadioButtonHelper.RadioButtonFieldTestType type1 = (RadioButtonHelper.RadioButtonFieldTestType)Enum.Parse(typeof(RadioButtonHelper.RadioButtonFieldTestType), type);
                radioButtonField = helper.GetRadioButtonField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.AddRadioButtonField(name, outPath, radioButtonField, folder, storage, password);
            }

        }

        public static void AddTextBoxField()
        {
            TextBoxHelper helper = null;
            TextBoxField textBoxField = null;
            string password = null;
            string storage = null;
            string outPath = "";

            string folder = "input";
            string name = "Sample.pdf";

            foreach (string type in Enum.GetNames(typeof(TextBoxHelper.TextBoxFieldTestType)))
            {
                helper = new TextBoxHelper();

                TextBoxHelper.TextBoxFieldTestType type1 = (TextBoxHelper.TextBoxFieldTestType)Enum.Parse(typeof(TextBoxHelper.TextBoxFieldTestType), type);
                textBoxField = helper.GetTextBoxField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.AddTextBoxField(name, outPath, textBoxField, folder, storage, password);
            }
        }

        public static void DeleteFieldByName()
        {
            string name = "ArcoForm.pdf";
            string outPath = "output/DeleteFieldByName.pdf";
            string fieldName = "country";
            string password = null;
            string folder = "input";
            string storage = null;
            pdfAcroFormApi.DeleteFieldByName(name, outPath, fieldName,  folder, storage, password);
        }

        public static void ExportFormDataFormat()
        {          
            string name = "FormData.pdf";
            string fieldName = "country";
            string fdfOutputFilePath = "output/Export.fdf";
            string password = null;
            string folder = "input";
            string storage = null;
            pdfAcroFormApi.ExportFormDataFormat(name, fieldName, fdfOutputFilePath, folder, storage,password);
        }

        public static void ExportXmlFormDataFormat()
        {
            string name = "FormData.pdf";
            string fieldName = "country";
            string xfdfOutputFilePath = "output/Export.xfdf";
            string password = null;
            string folder = "input";
            string storage = null;
            pdfAcroFormApi.ExportXmlFormDataFormat(name, fieldName, xfdfOutputFilePath, folder, storage, password);
        }

        public static void FlattenFields()
        {
            string name = "ArcoForm.pdf";
            string outPath = "output/FlattenFields.pdf";
            string password = null;
            string folder = "input";
            string storage = null;
            pdfAcroFormApi.FlattenFields(name, outPath, folder, storage, password);
        }

        public static void GetAllFieldsInformation()
        {
            string name = "ArcoForm.pdf";
            string password = null;
            string storage = null;
            string folder = "input";
            Fields response = pdfAcroFormApi.GetAllFieldsInformation(name, folder, storage, password);
        }

        public static void GetCheckBoxFieldInfo()
        {
            string password = null;
            string storage = null;
            string fieldName = "agreement_of_terms";
            string folder = "input";
            string name = "ArcoForm.pdf";

            CheckBoxField response = pdfAcroFormApi.GetCheckBoxFieldinfo(name, fieldName, folder, storage, password);
        }

        public static void GetComboBoxFieldInfo()
        {
            string name = "ArcoForm.pdf";
            string fieldName = "title";
            string password = null;
            string storage = null;
            string folder = "input";

            ComboBoxField response = pdfAcroFormApi.GetComboBoxFieldinfo(name, fieldName, folder, storage, password);
        }

        public static void GetListBoxFieldInfo()
        {         
            string name = "ArcoForm.pdf";
            string fieldName = "email_format";
            string password = null;
            string storage = null;
            string folder = "input";

            ListBoxField response = pdfAcroFormApi.GetListBoxFieldinfo(name, fieldName, folder, storage, password);
        }
        public static void GetPushButtonFieldInfo()
        {
            string password = null;
            string storage = null;

            string fieldName = "submit";
            string folder = "input";
            string name = "ArcoForm.pdf";

            PushButtonField response = pdfAcroFormApi.GetPushButtonFieldinfo(name, fieldName, folder, storage, password);
        }

        public static void GetRadioButtonFieldInfo()
        {
            string name = "ArcoForm.pdf";
            string fieldName = "country";
            string password = null;
            string storage = null;
            string folder = "input";

            RadioButtonField response = pdfAcroFormApi.GetRadioButtonFieldinfo(name, fieldName, folder, storage, password);
        }

        public static void GetTextBoxFieldInfo()
        {
            string password = null;
            string storage = null;

            string fieldName = "fax";
            string folder = "input";
            string name = "ArcoForm.pdf";

            TextBoxField response = pdfAcroFormApi.GetTextBoxFieldinfo(name, fieldName, folder, storage, password);
        }

        public static void ImportFormDataFormat()
        {
            string name = "FDF.pdf";
            string outPath = "output/ImportFdf.pdf";
            string fdfFilePath = "export.fdf";
            string password = null;
            string folder = "input";
            string storage = null;
            pdfAcroFormApi.ImportFormDataFormat(name, outPath, fdfFilePath, folder, storage, password);
        }

        public static void ImportXmlFormDataFormat()
        { 
            string name = "XFDF.pdf";
            string outPath = "output/ImportXfdf.pdf";
            string xfdfFilePath = "export.xfdf";
            string password = null;
            string folder = "input";
            string storage = null;
            pdfAcroFormApi.ImportXmlFormDataFormat(name, outPath, xfdfFilePath, folder, storage, password);
        }

        public static void UpdateCheckBoxField()
        {
            CheckBoxHelper helper = null;
            CheckBoxField checkBoxField = null;
            string password = null;
            string storage = null;
            string outPath = "";

            string fieldName = "agreement_of_terms";
            string folder = "input";
            string name = "ArcoForm.pdf";

            foreach (string type in Enum.GetNames(typeof(CheckBoxHelper.CheckBoxFieldTestType)))
            {
                if (type == "Required")
                    continue;

                helper = new CheckBoxHelper();

                CheckBoxHelper.CheckBoxFieldTestType type1 = (CheckBoxHelper.CheckBoxFieldTestType)Enum.Parse(typeof(CheckBoxHelper.CheckBoxFieldTestType), type);
                checkBoxField = helper.GetCheckBoxField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.UpdateCheckBoxField(name, outPath, fieldName, checkBoxField, folder, storage, password);
            }
        }

        public static void UpdateComboBoxField()
        {
            string fieldName = "title";
            ComboBoxHelper helper = null;
            string name = "ArcoForm.pdf";
            string outPath = "";
            ComboBoxField comboBoxField = null;
            string password = null;
            string storage = null;
            string folder = "input";

            foreach (string type in Enum.GetNames(typeof(ComboBoxHelper.ComboBoxFieldTestType)))
            {
                if (type == "Required")
                    continue;

                helper = new ComboBoxHelper();
                ComboBoxHelper.ComboBoxFieldTestType type1 = (ComboBoxHelper.ComboBoxFieldTestType)Enum.Parse(typeof(ComboBoxHelper.ComboBoxFieldTestType), type);

                comboBoxField = helper.GetComboBoxField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.UpdateComboBoxField(name, outPath, fieldName, comboBoxField, folder, storage, password);
            }
        }

        public static void UpdateFields()
        {
            FieldHelper helper = null;
            List<Field> fl = new List<Field>();
            Fields list = null;
            Field field = null;
            string password = null;
            string outPath = "";

            string folder = "input";
            string name = "ArcoForm.pdf";
            string storage = null;
            foreach (string type in Enum.GetNames(typeof(FieldHelper.FieldTestType)))
            {
                foreach (string fieldType in Enum.GetNames(typeof(Field.TypeEnum)))
                {
                    helper = new FieldHelper();
                    helper.f_type = (Field.TypeEnum)Enum.Parse(typeof(Field.TypeEnum), fieldType, true);

                    FieldHelper.FieldTestType type1 = (FieldHelper.FieldTestType)Enum.Parse(typeof(FieldHelper.FieldTestType), type);

                    field = helper.GetField(type1);
                    fl.Add(field);
                    list = new Fields(fl);
                    outPath = "output/" + type1 + ".pdf";
                    pdfAcroFormApi.UpdateFields(name, outPath, list, folder, storage, password);
                    fl.Clear();
                }
            }
        }
        public static void UpdateListBoxField()
        {
            ListBoxHelper helper = null;
            ListBoxField listBoxField = null;
            string password = null;
            string storage = null;
            string outPath = "";

            string fieldName = "email_format";
            string folder = "input";
            string name = "ArcoForm.pdf";

            foreach (string type in Enum.GetNames(typeof(ListBoxHelper.ListBoxFieldTestType)))
            {
                if (type == "Required")
                    continue;

                helper = new ListBoxHelper();

                ListBoxHelper.ListBoxFieldTestType type1 = (ListBoxHelper.ListBoxFieldTestType)Enum.Parse(typeof(ListBoxHelper.ListBoxFieldTestType), type);
                listBoxField = helper.GetListBoxField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.UpdateListBoxField(name, outPath, fieldName, listBoxField, folder, storage, password);
            }
        }

        public static void UpdatePushButtonField()
        {
            PushButtonHelper helper = null;
            PushButtonField pushButtonField = null;
            string password = null;
            string storage = null;
            string outPath = "";

            string fieldName = "submit";
            string folder = "input";
            string name = "ArcoForm.pdf";

            foreach (string type in Enum.GetNames(typeof(PushButtonHelper.PushButtonFieldTestType)))
            {
                if (type == "Required")
                    continue;

                helper = new PushButtonHelper();

                PushButtonHelper.PushButtonFieldTestType type1 = (PushButtonHelper.PushButtonFieldTestType)Enum.Parse(typeof(PushButtonHelper.PushButtonFieldTestType), type);
                pushButtonField = helper.GetPushButtonField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.UpdatePushButtonField(name, outPath, fieldName, pushButtonField, folder, storage, password);
            }
        }

        public static void UpdateRadioButtonField()
        {
            RadioButtonHelper helper = null;
            RadioButtonField radioButtonField = null;
            string password = null;
            string storage = null;
            string outPath = "";

            string fieldName = "country";
            string folder = "input";
            string name = "ArcoForm.pdf";

            foreach (string type in Enum.GetNames(typeof(RadioButtonHelper.RadioButtonFieldTestType)))
            {
                if (type == "Required")
                    continue;

                helper = new RadioButtonHelper();

                RadioButtonHelper.RadioButtonFieldTestType type1 = (RadioButtonHelper.RadioButtonFieldTestType)Enum.Parse(typeof(RadioButtonHelper.RadioButtonFieldTestType), type);
                radioButtonField = helper.GetRadioButtonField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.UpdateRadioButtonField(name, outPath, fieldName, radioButtonField, folder, storage, password);
            }
        }

        public static void UpdateTextBoxField()
        {
            TextBoxHelper helper = null;
            TextBoxField textBoxField = null;
            string password = null;
            string storage = null;
            string outPath = "";

            string fieldName = "fax";
            string folder = "input";
            string name = "ArcoForm.pdf";

            foreach (string type in Enum.GetNames(typeof(TextBoxHelper.TextBoxFieldTestType)))
            {
                if (type == "Required")
                    continue;

                helper = new TextBoxHelper();

                TextBoxHelper.TextBoxFieldTestType type1 = (TextBoxHelper.TextBoxFieldTestType)Enum.Parse(typeof(TextBoxHelper.TextBoxFieldTestType), type);
                textBoxField = helper.GetTextBoxField(type1);
                outPath = "output/" + type1 + ".pdf";
                pdfAcroFormApi.UpdateTextBoxField(name, outPath, fieldName, textBoxField, folder, storage, password);
            }
        }
    }
}
