﻿using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Spire.Cloud.Pdf.Sdk.TestHelper
{
    internal class TableTestHelper
    {
        public enum TableTestType
        {
            TestRequiredItem,
            GlobalTextAlignment,
            GlobalVerticalAlignment,
            GlobalCharaSpace,
            GlobalWordSpace,
            Font,
            TextBackGroundColor,
            TextForeGroundColor,
            LocalTextAlignment,
            LocalVerticalAlignment,
            LocalCharaSpace,
            LocalWordSpace,
            CellBorder,
            CellBackGroundColor,
            RowSpan,
            ColumnSpan,
            TableHeader,
        }
        private readonly float rowHeight = 40;
        private readonly float columnWidth = 80;
        private readonly PointF point = new PointF(30, 250);


        private string[] rowsitem = "China,960,14,Asian,Panda;America,937,3.27,South America,Haliaeetus leucocephalus;".Split(';');
        private TableTestType f_TableTestType;

        internal Table GetTable(TableTestType type)
        {
            f_TableTestType = type;
            switch (f_TableTestType)
            {
                case TableTestType.TestRequiredItem:
                    return CreateRequiredItemsTable();

                case TableTestType.GlobalTextAlignment:
                    return CreateGlobalStringFormatTable();

                case TableTestType.GlobalVerticalAlignment:
                    return CreateGlobalStringFormatTable();

                case TableTestType.GlobalWordSpace:
                    return CreateGlobalStringFormatTable();

                case TableTestType.GlobalCharaSpace:
                    return CreateGlobalStringFormatTable();


                case TableTestType.Font:
                    return CreateTableByCellStyle();

                case TableTestType.TextBackGroundColor:
                    return CreateTableByCellStyle();

                case TableTestType.TextForeGroundColor:
                    return CreateTableByCellStyle();

                case TableTestType.CellBorder:
                    return CreateTableByCellStyle();

                case TableTestType.LocalTextAlignment:
                    return CreateTableByCellStyle();

                case TableTestType.LocalVerticalAlignment:
                    return CreateTableByCellStyle();

                case TableTestType.LocalCharaSpace:
                    return CreateTableByCellStyle();

                case TableTestType.LocalWordSpace:
                    return CreateTableByCellStyle();

                case TableTestType.CellBackGroundColor:
                    return CreateTableByCellStyle();


                case TableTestType.RowSpan:
                    return CreateTableOfSpan();

                case TableTestType.ColumnSpan:
                    return CreateTableOfSpan();

                case TableTestType.TableHeader:
                    return CreateTableOfHeader();
            }
            return null;
        }

        private Table CreateRequiredItemsTable()
        {
            string[] rowsitem = "China,960,14,Asian,Panda;America,937,3.27,South America,Haliaeetus leucocephalus;".Split(';');

            // Create Row 
            List<TableRow> rowlist = new List<TableRow>();
            TableRow row = null;
            for (int i = 0; i < 2; i++)
            {
                //Create cells
                TableCell cell = null;
                List<TableCell> celllist = new List<TableCell>();
                string[] rowstring = rowsitem[i].Split(',');
                for (int j = 0; j < 5; j++)
                {
                    TextElement TextElement = new TextElement(rowstring[j]);
                    cell = new TableCell(TextElement);
                    celllist.Add(cell);
                }

                row = new TableRow(rowHeight, celllist);
                rowlist.Add(row);
            }

            //Create Column
            List<TableColumn> columnlist = new List<TableColumn>();
            TableColumn column = null;
            for (int i = 0; i < 5; i++)
            {
                column = new TableColumn(columnWidth + 5 * i);
                columnlist.Add(column);
            }

            Table table = new Table(point, null, rowlist, columnlist);

            return table;
        }

        private Table CreateGlobalStringFormatTable()
        {
            string[] rowsitem = "China,960,14,Asian,Panda;America,937,3.27,South America,Haliaeetus leucocephalus;".Split(';');

            // Create Row 
            List<TableRow> rowlist = new List<TableRow>();
            TableRow row = null;
            for (int i = 0; i < 2; i++)
            {
                //Create cells
                TableCell cell = null;
                List<TableCell> celllist = new List<TableCell>();
                string[] rowstring = rowsitem[i].Split(',');
                for (int j = 0; j < 5; j++)
                {
                    TextElement TextElement = new TextElement(rowstring[j]);
                    cell = new TableCell(TextElement);
                    celllist.Add(cell);
                }

                row = new TableRow(rowHeight, celllist);
                rowlist.Add(row);
            }

            //Create Column
            List<TableColumn> columnlist = new List<TableColumn>();
            TableColumn column = null;
            for (int i = 0; i < 5; i++)
            {
                column = new TableColumn(columnWidth + 5 * i);
                StringFormat stringformat = new StringFormat();

                if (f_TableTestType == TableTestType.GlobalTextAlignment)
                {
                    stringformat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                }
                if (f_TableTestType == TableTestType.GlobalVerticalAlignment)
                {
                    stringformat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                    stringformat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                }
                if (f_TableTestType == TableTestType.GlobalCharaSpace)
                {
                    stringformat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                    stringformat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                    stringformat.CharacterSpacing = 0.5f;
                }
                if (f_TableTestType == TableTestType.GlobalWordSpace)
                {
                    stringformat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                    stringformat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                    stringformat.CharacterSpacing = 0.5f;
                    stringformat.WordSpacing = 5;
                }
                column.StringFormat = stringformat;
                columnlist.Add(column);
            }

            Table table = new Table(point, null, rowlist, columnlist);

            return table;
        }


        private Table CreateTableByCellStyle()
        {
            string[] rowsitem = "China,960,14,Asian,Panda;America,937,3.27,South America,Haliaeetus leucocephalus;".Split(';');

            // Create Row 
            List<TableRow> rowlist = new List<TableRow>();
            TableRow row = null;
            for (int i = 0; i < 2; i++)
            {
                //Create cells
                TableCell cell = null;
                List<TableCell> celllist = new List<TableCell>();
                string[] rowstring = rowsitem[i].Split(',');
                for (int j = 0; j < 5; j++)
                {
                    TextElement TextElement = new TextElement(rowstring[j]);
                    Font font = new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Regular);
                    Color TextForeGroundColor = new Color(10, 255, 0, 0);
                    Color TextBackGrounColor = new Color(10, 70, 125, 170);
                    StringFormat StringFormat = new StringFormat();

                    if (f_TableTestType == TableTestType.Font)
                    {
                        TextElement.Font = font;
                    }
                    if (f_TableTestType == TableTestType.TextBackGroundColor)
                    {
                        TextElement.Font = font;
                        TextElement.BackGroundColor = TextBackGrounColor;
                    }
                    if (f_TableTestType == TableTestType.TextForeGroundColor)
                    {
                        TextElement.Font = font;
                        TextElement.BackGroundColor = TextBackGrounColor;
                        TextElement.ForeGroundColor = TextForeGroundColor;
                    }
                    if (f_TableTestType == TableTestType.LocalTextAlignment)
                    {
                        TextElement.Font = font;
                        TextElement.BackGroundColor = TextBackGrounColor;
                        TextElement.ForeGroundColor = TextForeGroundColor;
                        StringFormat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                    }
                    if (f_TableTestType == TableTestType.LocalVerticalAlignment)
                    {
                        TextElement.Font = font;
                        TextElement.BackGroundColor = TextBackGrounColor;
                        TextElement.ForeGroundColor = TextForeGroundColor;
                        StringFormat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                        StringFormat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;

                    }
                    if (f_TableTestType == TableTestType.LocalCharaSpace)
                    {
                        TextElement.Font = font;
                        TextElement.BackGroundColor = TextBackGrounColor;
                        TextElement.ForeGroundColor = TextForeGroundColor;
                        StringFormat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                        StringFormat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                        StringFormat.CharacterSpacing = 0.5f;
                    }
                    if (f_TableTestType == TableTestType.LocalWordSpace)
                    {
                        TextElement.Font = font;
                        TextElement.BackGroundColor = TextBackGrounColor;
                        TextElement.ForeGroundColor = TextForeGroundColor;
                        StringFormat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                        StringFormat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                        StringFormat.CharacterSpacing = 0.5f;
                        StringFormat.WordSpacing = 5f;
                    }
                    if (f_TableTestType == TableTestType.CellBorder || f_TableTestType == TableTestType.CellBackGroundColor)
                    {
                        TextElement.Font = font;
                        TextElement.BackGroundColor = TextBackGrounColor;
                        TextElement.ForeGroundColor = TextForeGroundColor;
                        StringFormat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                        StringFormat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                        StringFormat.CharacterSpacing = 0.5f;
                        StringFormat.WordSpacing = 5f;
                    }
                    TextElement.StringFormat = StringFormat;
                    cell = new TableCell(TextElement);
                    if (f_TableTestType == TableTestType.CellBorder)
                    {
                        TableBorder TableBorder = new TableBorder(new Color(15, 25, 25, 100), 1.5f);
                        cell.TableBorder = TableBorder;
                    }
                    if (f_TableTestType == TableTestType.CellBackGroundColor)
                    {
                        TableBorder TableBorder = new TableBorder(new Color(15, 25, 25, 100), 1.5f);
                        Color CellBackGroundColor = new Color(15, 230, 230, 230);
                        cell.TableBorder = TableBorder;
                        cell.BackGroundColor = CellBackGroundColor;
                    }
                    celllist.Add(cell);
                }

                row = new TableRow(rowHeight, celllist);
                rowlist.Add(row);
            }

            //Create Column
            List<TableColumn> columnlist = new List<TableColumn>();
            TableColumn column = null;
            for (int i = 0; i < 5; i++)
            {
                column = new TableColumn(columnWidth + 5 * i);
                //StringFormat stringformat = new StringFormat();
                //stringformat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                //stringformat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                //stringformat.CharacterSpacing = 0.5f;
                //stringformat.WordSpacing = 5;
                //column.StringFormat = stringformat;
                columnlist.Add(column);
            }

            Table table = new Table(point, null, rowlist, columnlist);

            return table;
        }

        private Table CreateTableOfSpan()
        {
            string[] rowsitem = "China,960,14,Asian,Panda;Japanese,37.8,1.27,Asian,Crested Ibis;".Split(';');

            // Create Row 
            List<TableRow> rowlist = new List<TableRow>();
            TableRow row = null;
            for (int i = 0; i < 2; i++)
            {
                //Create cells
                TableCell cell = null;
                List<TableCell> celllist = new List<TableCell>();
                string[] rowstring = rowsitem[i].Split(',');
                for (int j = 0; j < 5; j++)
                {
                    TextElement TextElement = new TextElement(rowstring[j]);
                    Font font = new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Regular);
                    Color TextForeGroundColor = new Color(10, 255, 0, 0);
                    Color TextBackGrounColor = new Color(10, 70, 125, 170);
                    StringFormat StringFormat = new StringFormat();

                    TextElement.Font = font;
                    TextElement.BackGroundColor = TextBackGrounColor;
                    TextElement.ForeGroundColor = TextForeGroundColor;
                    StringFormat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                    StringFormat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                    StringFormat.CharacterSpacing = 0.5f;
                    StringFormat.WordSpacing = 5f;
                    TextElement.StringFormat = StringFormat;

                    cell = new TableCell(TextElement);

                    TableBorder TableBorder = new TableBorder(new Color(15, 25, 25, 100), 1.5f);
                    Color CellBackGroundColor = new Color(15, 230, 230, 230);
                    cell.TableBorder = TableBorder;
                    cell.BackGroundColor = CellBackGroundColor;

                    if (f_TableTestType == TableTestType.RowSpan && i == 0 && j == 3)
                    {
                        cell.RowSpan = 2;
                    }
                    if (f_TableTestType == TableTestType.ColumnSpan && i == 0 && j == 1)
                    {
                        cell.ColumnSpan = 2;
                        cell.TextElement.Text = "vast territory and abundant resources";
                    }
                    celllist.Add(cell);
                }

                row = new TableRow(rowHeight, celllist);
                rowlist.Add(row);
            }

            //Create Column
            List<TableColumn> columnlist = new List<TableColumn>();
            TableColumn column = null;
            for (int i = 0; i < 5; i++)
            {
                column = new TableColumn(columnWidth + 5 * i);
                columnlist.Add(column);
            }

            Table table = new Table(point, null, rowlist, columnlist);

            return table;
        }


        private Table CreateTableOfHeader()
        {
            string[] headerItems = "Country,Area,Population,geography,NationalTreasure".Split(',');
            string[] rowsitem = "China,960,14,Asian,Panda;Japanese,37.8,1.27,Asian,Crested Ibis;".Split(';');

            //Create header
            TableRow header = null;
            TableCell headerCell = null;
            List<TableCell> headerCelllist = new List<TableCell>();
            for (int j = 0; j < 5; j++)
            {
                TextElement TextElement = new TextElement(headerItems[j]);
                Font font = new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Regular);
                Color TextForeGroundColor = new Color(10, 255, 0, 0);
                Color TextBackGrounColor = new Color(10, 70, 125, 170);
                StringFormat StringFormat = new StringFormat();

                TextElement.Font = font;
                TextElement.BackGroundColor = TextBackGrounColor;
                TextElement.ForeGroundColor = TextForeGroundColor;
                StringFormat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                StringFormat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                StringFormat.CharacterSpacing = 0.5f;
                StringFormat.WordSpacing = 5f;
                TextElement.StringFormat = StringFormat;

                headerCell = new TableCell(TextElement);

                TableBorder TableBorder = new TableBorder(new Color(15, 25, 25, 100), 1.5f);
                Color CellBackGroundColor = new Color(15, 230, 230, 230);
                headerCell.TableBorder = TableBorder;
                headerCell.BackGroundColor = CellBackGroundColor;

                headerCelllist.Add(headerCell);
            }

            header = new TableRow(rowHeight, headerCelllist);


            // Create Row 
            List<TableRow> rowlist = new List<TableRow>();
            TableRow row = null;
            for (int i = 0; i < 2; i++)
            {
                //Create cells
                TableCell cell = null;
                List<TableCell> celllist = new List<TableCell>();
                string[] rowstring = rowsitem[i].Split(',');
                for (int j = 0; j < 5; j++)
                {
                    TextElement TextElement = new TextElement(rowstring[j]);
                    Font font = new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Regular);
                    Color TextForeGroundColor = new Color(10, 255, 0, 0);
                    Color TextBackGrounColor = new Color(10, 70, 125, 170);
                    StringFormat StringFormat = new StringFormat();

                    TextElement.Font = font;
                    TextElement.BackGroundColor = TextBackGrounColor;
                    TextElement.ForeGroundColor = TextForeGroundColor;
                    StringFormat.TextAlignment = StringFormat.TextAlignmentEnum.Center;
                    StringFormat.VerticalAlignment = StringFormat.VerticalAlignmentEnum.Middle;
                    StringFormat.CharacterSpacing = 0.5f;
                    StringFormat.WordSpacing = 5f;
                    TextElement.StringFormat = StringFormat;

                    cell = new TableCell(TextElement);

                    TableBorder TableBorder = new TableBorder(new Color(15, 25, 25, 100), 1.5f);
                    Color CellBackGroundColor = new Color(15, 230, 230, 230);
                    cell.TableBorder = TableBorder;
                    cell.BackGroundColor = CellBackGroundColor;

                    if (i == 0 && j == 3)
                    {
                        cell.RowSpan = 2;
                    }
                    if( i == 0 && j == 1)
                    {
                        cell.ColumnSpan = 2;
                        cell.TextElement.Text = "vast territory and abundant resources";
                    }
                    celllist.Add(cell);
                }

                row = new TableRow(rowHeight, celllist);
                rowlist.Add(row);
            }

            //Create Column
            List<TableColumn> columnlist = new List<TableColumn>();
            TableColumn column = null;
            for (int i = 0; i < 5; i++)
            {
                column = new TableColumn(columnWidth + 8 * i);
                columnlist.Add(column);
            }

            Table table = new Table(point, header, rowlist, columnlist);

            return table;
        }
    }
}
