﻿using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spire.Cloud.Pdf.Sdk.Model.RadioButtonField;

namespace Spire.Cloud.Pdf.Sdk.Test.TestHelper
{
    internal class RadioButtonHelper
    {

        internal enum RadioButtonFieldTestType
        {
            Required,
            MappingName,
            ToolTip,
            SelectedIndexs,

        }
        public RadioButtonField GetRadioButtonField(RadioButtonFieldTestType testType)
        {
            switch (testType)
            {
                case RadioButtonFieldTestType.Required:
                    return SimpleRadioButtonField();

                case RadioButtonFieldTestType.MappingName:
                    return MappingNameRadioButtonField();

                case RadioButtonFieldTestType.ToolTip:
                    return ToolTipRadioButtonField();

                case RadioButtonFieldTestType.SelectedIndexs:
                    return SelectedIndexsRadioButtonField();
            }
            return null;
        }

        private RadioButtonField SimpleRadioButtonField()
        {
            RadioButtonField RadioButton = SetRequiredProperties();
            List<string> values = new List<string>() { "PDF", "XLS", "PPT" };
            RadioButton.Values = values;
            return RadioButton;
        }
        private RadioButtonField MappingNameRadioButtonField()
        {
            RadioButtonField RadioButton = SetRequiredProperties();
            RadioButton.MappingName = "RadioButtonMapingName";
            List<string> values = new List<string>() { "PDF", "XLS", "PPT" };
            RadioButton.Values = values;
            return RadioButton;
        }

        private RadioButtonField ToolTipRadioButtonField()
        {
            RadioButtonField RadioButton = SetRequiredProperties();
            RadioButton.MappingName = "RadioButtonMapingName";
            RadioButton.ToolTip = "RadioButtonToolTip";
            List<string> values = new List<string>() { "PDF", "XLS", "PPT" };
            RadioButton.Values = values;
            return RadioButton;
        }

        private RadioButtonField SelectedIndexsRadioButtonField()
        {
            RadioButtonField RadioButton = SetRequiredProperties();
            RadioButton.MappingName = "ListBoxMapingName";
            RadioButton.ToolTip = "ListBoxToolTip";
            List<string> values = new List<string>() { "PDF", "XLS", "PPT"};
            RadioButton.Values = values;
            RadioButton.SelectedIndex = 1;
            return RadioButton;
        }
        private RadioButtonField SetRequiredProperties()
        {
            List<RadioButtonFlagsEnum> RadioButtonFlags = new List<RadioButtonFlagsEnum>();
            RadioButtonFlags.Add(RadioButtonFlagsEnum.NoExport);
            RadioButtonFlags.Add(RadioButtonFlagsEnum.Required);

            string Name = "country";
            int PageIndex = 1;

            string Value = "";
            RectangleF Bounds = null;
            RadioButtonOptionField RrdioButtonOptionField = null;
            List<string> values = new List<string>() { "PDF", "XLS", "PPT" };
            List<RadioButtonOptionField> options = new List<RadioButtonOptionField>() ;

            for (int i = 0; i < 3; i++)
            {
                Bounds = new RectangleF(300 + 20 * i, 500, 10, 10);
                Value = values[i];
                RrdioButtonOptionField = new RadioButtonOptionField(Bounds, Value);
                options.Add(RrdioButtonOptionField);
            }
            return new RadioButtonField(PageIndex,RadioButtonFlags, Name, options);
        }
    }
}
