﻿using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spire.Cloud.Pdf.Sdk.Model.PushButtonField;

namespace Spire.Cloud.Pdf.Sdk.Test.TestHelper
{
    internal class PushButtonHelper
    {
        internal enum PushButtonFieldTestType
        {
            Required,
            MappingName,
            ToolTip,
            Value,
        }
        public PushButtonField GetPushButtonField(PushButtonFieldTestType testType)
        {
            switch (testType)
            {
                case PushButtonFieldTestType.Required:
                    return SimplePushButtonField();

                case PushButtonFieldTestType.MappingName:
                    return MappingNamePushButtonField();

                case PushButtonFieldTestType.ToolTip:
                    return ToolTipPushButtonField();

                case PushButtonFieldTestType.Value:
                    return ValuesPushButtonField();
            }
            return null;
        }

        private PushButtonField SimplePushButtonField()
        {
            PushButtonField PushButton = SetRequiredProperties();
            return PushButton;
        }
        private PushButtonField MappingNamePushButtonField()
        {
            PushButtonField PushButton = SetRequiredProperties();
            PushButton.MappingName = "PushButtonMapingName";
            return PushButton;
        }

        private PushButtonField ToolTipPushButtonField()
        {
            PushButtonField PushButton = SetRequiredProperties();
            PushButton.MappingName = "PushButtonMapingName";
            PushButton.ToolTip = "PushButtonToolTip";
            return PushButton;
        }
        private PushButtonField ValuesPushButtonField()
        {
            PushButtonField PushButton = SetRequiredProperties();
            PushButton.MappingName = "PushButtonMapingName";
            PushButton.ToolTip = "PushButtonToolTip";
            PushButton.Value = "Push It";
            return PushButton;
        }
        private PushButtonField SetRequiredProperties()
        {
            List<PushButtonFlagsEnum> PushButtonFlags = new List<PushButtonFlagsEnum>();
            PushButtonFlags.Add(PushButtonFlagsEnum.NoExport);
            PushButtonFlags.Add(PushButtonFlagsEnum.Required);

            RectangleF Bounds = new RectangleF(300, 500, 50, 25);
            string Name = "submit";
            int PageIndex = 1;

            return new PushButtonField(PushButtonFlags, Name, PageIndex, Bounds);
        }
    }
}
