﻿using Newtonsoft.Json.Linq;
using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using System.IO;
using System;

namespace SpireCloudSDK
{
    class Search_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration pdfConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static PdfAIApi pdfAIApi = new PdfAIApi(pdfConfiguration_AI);

        public static void Search()  
        {
            string name = "Search.txt";
            string folder = "output";
            string question = "茴香豆的茴字有几种写法？ 请用中文回答：";

            pdfAIApi.Search(name, question,null,null,null,folder,null);
        }
        public static void Search_EnableHistory()
        {
            string name = "Search_EnableHistory.txt";
            string language = "chinese";
            string question = "如何提高居民消费欲望,请列举三点";
            string folder = "output";
            bool enableHistory = true;

            pdfAIApi.Search(name, question, language, enableHistory, null, folder,null);
        }
        public static void Search_EnableHistoryWithId()
        {
            string name = "Search_EnableHistoryWithId.txt";
            string question = "我刚刚提到了什么？";
            string language = "English";
            bool enableHistory = true;
            string folder = "output";
            string conversationID = GetConversationID("output/Search_EnableHistory.txt");

            pdfAIApi.Search(name, question, language, enableHistory, conversationID, folder, null);
        }
        public static void Search_UnableHistory()
        {
            string name = "Search_UnableHistory.txt";
            string question = "how we can add a clickable URL to the Image as well?";
            string language = "Chinese";
            string folder = "output";
            bool enableHistory = false;

            pdfAIApi.Search(name, question, language, enableHistory, null, folder, null);
        }
        public static void Search_UnableHistoryWithId()
        {
            string name = "Search_UnableHistoryWithId.txt";
            string question = "我刚刚提到了什么？";
            string language = "Chinese";
            string folder = "output";
            bool enableHistory = false;
            string conversationID = GetConversationID("output/Search_EnableHistory.txt");

            pdfAIApi.Search(name, question, language, enableHistory, conversationID, folder, null);
        }
        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}