using Newtonsoft.Json.Linq;
using Spire.Cloud.Excel.Sdk.Api;
using Spire.Cloud.Excel.Sdk.Client;
using System.IO;
using System;
using System.Collections.Generic;

namespace SpireCloudSDK
{
    public class DocumentSearch_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration excelConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static ExcelAIApi excelAIApi = new ExcelAIApi(excelConfiguration_AI);

        public static void DocumentSearch()
        {
            string name = "sample.txt";
            string destFilePath = "output/DocumentSearch.txt";
            string question = "ĵʲôΪ̸3Ļ,ʹmarkdownбʽ";          
            string folder = "input";

            excelAIApi.DocumentSearch(name, destFilePath, question, null, null, null, folder, null);
        }
        public static void DocumentSearch_EnableHistory()
        {
            string name = "sample.txt";
            string destFilePath = "output/DocumentSearch_EnableHistory.txt";
            string question = "ƪ½ʲô Ļش";
            bool enableHistory = true;
            string folder = "input";

            excelAIApi.DocumentSearch(name, destFilePath, question, null, enableHistory, null, folder, null);
        }
        public static void DocumentSearch_EnableHistoryWithId()
        {
            string name = "sample.txt";
            string destFilePath = "output/DocumentSearch_EnableHistoryWithId.txt";
            string question = "ҸղŵҪʲôԻش";
            bool enableHistory = true;
            string conversationID = GetConversationID("output/DocumentSearch_EnableHistory.txt");
            string folder = "input";

            excelAIApi.DocumentSearch(name, destFilePath, question, null, enableHistory, conversationID, folder, null);
        }
        public static void DocumentSearch_UnableHistory()
        {
            string name = "sample.txt";
            string destFilePath = "output/DocumentSearch_UnableHistory.txt";
            string question = "ƪ½ʲô Ļش";
            bool enableHistory = false;
            string folder = "input";

            excelAIApi.DocumentSearch(name, destFilePath, question, null, enableHistory, null, folder, null);
        }
        public static void DocumentSearch_UnableHistoryWithId()
        {
            string name = "sample.txt";
            string destFilePath = "output/DocumentSearch_UnableHistoryWithId.txt";
            string question = "Ҹղʲô⣿";
            bool enableHistory = false;
            string folder = "input";
            string conversationID = GetConversationID("output/DocumentSearch_EnableHistory.txt");

            excelAIApi.DocumentSearch(name, destFilePath, question, null, enableHistory, conversationID, folder, null);
        }
        public static void DocumentSearch_Options()
        {
            string name = "sample.txt";
            string destFilePath = "output/DocumentSearch_Options.txt";
            string question = "ƪ½ʲô Ļش";
            bool enableHistory = false;
            var options = new Dictionary<string,string>();
            options.Add("search_type", "similarity");
            options.Add("search_kwargs", "{\"k\": 10}");
            string folder = "input";

            excelAIApi.DocumentSearch(name, destFilePath, question, options, enableHistory, null, folder, null);
        }
        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}
