using Newtonsoft.Json.Linq;
using Spire.Cloud.Excel.Sdk.Api;
using Spire.Cloud.Excel.Sdk.Client;
using System.IO;
using System;

namespace SpireCloudSDK
{
    public class Ask_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration excelConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static ExcelAIApi excelAIApi = new ExcelAIApi(excelConfiguration_AI);

        public static void Ask()
        {
            string name = "Ask.txt";
            string question = "дһ׹ڴԾ";         
            string folder = "output";

            excelAIApi.ASK(name, question, null, null, folder, null);
        }
        public static void Ask_EnableHistory()
        {
            string name = "Ask_EnableHistory.txt";
            string question = "Ƽķʽ뷵markdownʽ";
            bool enableHistory = true;
            string folder = "output";

            excelAIApi.ASK(name, question, enableHistory, null, folder, null);
        }
        public static void Ask_EnableHistoryWithId()
        {
            string name = "Ask_EnableHistoryWithId.txt";
            string question = "Ҹղ˹ڴʲô";
            bool enableHistory = true;
            string folder = "output";
            string conversationID = GetConversationID("output/Ask_EnableHistory.txt");

            excelAIApi.ASK(name, question, enableHistory, conversationID, folder, null);
        }

        public static void Ask_UnableHistory()
        {
            string name = "Ask_UnableHistory.txt";
            string question = "Ƽķʽ뷵markdownʽ";
            bool enableHistory = false;
            string folder = "output";

            excelAIApi.ASK(name, question, enableHistory, null, folder, null);
        }

        public static void Ask_UnableHistoryWithId()
        {
            string name = "Ask_UnableHistoryWithId.txt";
            string question = "ղʲô";
            bool enableHistory = false;
            string folder = "output";
            string conversationID = GetConversationID("output/Ask_EnableHistory.txt");

            excelAIApi.ASK(name, question, enableHistory, conversationID, folder, null);
        }
        public static void AskWithId()
        {
            string name = "AskWithId.txt";
            string question = "ղʲô";
            string folder = "output";
            string conversationID = GetConversationID("output/Ask_EnableHistory.txt");

            excelAIApi.ASK(name, question, null, conversationID, folder, null);
        }
        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}
