<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfWartermarkApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\Font;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;
use Spire\Cloud\Pdf\Sdk\Model\Text;
use Spire\Cloud\Pdf\Sdk\Model\TextWartermark;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfWartermarkApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddTextWartermark.pdf";
$pageNumber = 1;
$folder = "input";
$textArray=[
    'value' => 'This is a test.',
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Regular"]),
    'rect' => new RectangleF(['x' => 10, 'y' => 10, 'width' => 100, 'height' => 50]),
    'foreground_color' => new Color(['a' => 100,'r' => 255,'g' => 0,'b' => 0]),
    'background_color' => new Color(['a' => 100,'r' => 0,'g' => 0,'b' => 255]),
    'horizontal_alignment' => null,
    'vertical_alignment' => null,
    'word_wrap' => null,
    'char_spacing' => null,
    'word_spacing' => null,
    'line_spacing' => null,
    'first_line_indent' => null
];
$text = new Text($textArray);
$textWartermarkArray=[
    'rect' => new RectangleF(['x' => 10,'y' => 10,'width' => 500,'height' => 500]),
    'text' => $text,
    'horizontal_copies' => 2,
    'vertical_copies' => 3,
    'transparency' => 0.3,
    'rotation_angle' => 45
];
$textWartermark = new TextWartermark($textWartermarkArray);
$result =$apiInstance->addTextWartermark($name, $outPath, $pageNumber, $textWartermark, $folder, null);