<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfTextApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\Font;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;
use Spire\Cloud\Pdf\Sdk\Model\Text;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfTextApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddText_StandardRegular.pdf";
$pageNumber = 1;
$folder = "input";
$password = "test";
$textArray = [
    'value' => 'This is a test.',
    #supports font_type/font_style: Standard/Regular;Standard/Bold;Standard/Italic;Standard/BoldItalic;TrueType/Regular;TrueType/Bold;TrueType/Italic;TrueType/BoldItalic
     # UnicodeTrueType/Regular;UnicodeTrueType/Bold;UnicodeTrueType/Italic;UnicodeTrueType/BoldItalic;
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Regular"]),
    'rect' => new RectangleF(['x' => 10, 'y' => 10, 'width' => 500, 'height' => 800]),
    'foreground_color' => new Color(['a' => 1, 'r' => 120, 'g' => 0, 'b' => 139]),
    'background_color' => new Color(['a' => 1, 'r' => 120, 'g' => 182, 'b' => 193]),
    'horizontal_alignment' => null,
    'vertical_alignment' => null,
    #supports WrapWords:Word/Character/WordOnly/None
    'word_wrap' => 'Word',
    'char_spacing' => null,
    'word_spacing' => null,
    'line_spacing' => null,
    'first_line_indent' => null
];
$text = new Text($textArray);
#Just removeing "$password" if there is no password
$result =$apiInstance->addText($name, $outPath, $pageNumber, $text, $folder, null, $password);
