<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfBarcodeApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Barcode;
use Spire\Cloud\Pdf\Sdk\Model\Font;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfBarcodeApi($configuration);

$outPath = "output/Codabar.png"; //Supported types: Codabar, Code11, Code128A, Code128B, Code128C, Code32, Code39, Code39Extended, Code93, Code93Extended
$font = new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]);
$barcode = new Barcode(['x' => 50, 'y' => 50, 'width' => null, 'height' => null,
    'type' => 'Codabar', 'text' => '123456789', 'font' => $font, 'barcode_to_text_gap_height' => 1, 'enable_check_digit' => true, 'show_check_digit' => true, 'text_display_location' => 'Bottom']);
$apiInstance->generatePng($barcode, $outPath, null);
