<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfBarcodeApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Barcode;
use Spire\Cloud\Pdf\Sdk\Model\Font;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfBarcodeApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddBarcode.pdf";
$pageNumber = 1;
$password = null;
$folder = "input";

$font = new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]);
$barcode1 = new Barcode(['x' => 50, 'y' => 50, 'width' => 50, 'height' => 50,
    'type' => 'Codabar', 'text' => '123456789', 'font' => $font, 'barcode_to_text_gap_height' => 1, 'enable_check_digit' => true, 'show_check_digit' => true, 'text_display_location' => 'Bottom']);
$barcode2 = new Barcode(['x' => 50, 'y' => 150, 'width' => 50, 'height' => 50,
    'type' => 'Code11', 'text' => '123-4567890', 'font' => null, 'barcode_to_text_gap_height' => 1, 'enable_check_digit' => true, 'show_check_digit' => true, 'text_display_location' => 'Top']);
$barcode3 = new Barcode(['x' => 50, 'y' => 250, 'width' => 50, 'height' => 50,
    'type' => 'Code128A', 'text' => 'HELLO 00-123', 'font' => null, 'barcode_to_text_gap_height' => 1, 'enable_check_digit' => true, 'show_check_digit' => true, 'text_display_location' => 'None']);
$barcode4 = new Barcode(['x' => 50, 'y' => 350, 'width' => 50, 'height' => 50,
    'type' => 'Code128B', 'text' => 'Hello 00-123', 'font' => null]);
$barcode5 = new Barcode(['x' => 50, 'y' => 450, 'width' => 50, 'height' => 50,
    'type' => 'Code128C', 'text' => '00253645', 'font' => null]);
$barcode6 = new Barcode(['x' => 300, 'y' => 50, 'width' => 50, 'height' => 50,
    'type' => 'Code32', 'text' => '16273849', 'font' => null, 'barcode_to_text_gap_height' => 0, 'enable_check_digit' => true, 'show_check_digit' => true, 'text_display_location' => 'Top']);
$barcode7 = new Barcode(['x' => 300, 'y' => 150, 'width' => 50, 'height' => 50,
    'type' => 'Code39', 'text' => '16-273849', 'font' => null, 'barcode_to_text_gap_height' => 0, 'enable_check_digit' => false, 'show_check_digit' => false, 'text_display_location' => 'Top']);
$barcode8 = new Barcode(['x' => 300, 'y' => 250, 'width' => 50, 'height' => 50,
    'type' => 'Code39Extended', 'text' => '16-273849', 'font' => null, 'barcode_to_text_gap_height' => 0, 'enable_check_digit' => true, 'show_check_digit' => true, 'text_display_location' => 'None']);
$barcode9 = new Barcode(['x' => 300, 'y' => 350, 'width' => 50, 'height' => 50,
    'type' => 'Code93', 'text' => '16-273849', 'font' => null, 'barcode_to_text_gap_height' => 0, 'enable_check_digit' => true, 'show_check_digit' => false, 'text_display_location' => 'Bottom']);
$barcode10 = new Barcode(['x' => 300, 'y' => 450, 'width' => 50, 'height' => 50,
    'type' => 'Code93Extended', 'text' => '16-273849', 'font' => null, 'barcode_to_text_gap_height' => 0, 'enable_check_digit' => false, 'show_check_digit' => true, 'text_display_location' => 'Top']);

$list = array($barcode1, $barcode2, $barcode3, $barcode4, $barcode5, $barcode6, $barcode7, $barcode8, $barcode9, $barcode10);
$apiInstance->addBarcode($name, $outPath, $pageNumber, $list, $folder, $password);