<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperance;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperanceImage;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperanceText;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\PopupAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\Font;
use Spire\Cloud\Pdf\Sdk\Model\PointF;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "ReplacePopupAnnotationByID.pdf";
$outPath = "output/ReplacePopupAnnotationByID.pdf";
$id = "1-4";
$password = null;
$folder = "input";

$text = new AnnotationApperanceText([
    'value' => "This is a test! ",
    'font'=> new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]),
    'rect'=> new RectangleF(['x' => 10, 'y' => 10, 'width' => 80, 'height' => 20]),
    'foreground_color' => null,
    'background_color' => new Color(['a' => 255,'r' => 0,'g' => 0,'b' => 0]),
    'horizontal_alignment' => null,
    'vertical_alignment' => null,
    'word_wrap' => null,
    'char_spacing' => null,
    'word_spacing' => null,
    'line_spacing' => null,
    'first_line_indent' => null
]);
$image = new AnnotationApperanceImage([
    'position' => new PointF(['x' => 50, 'y' => 50]),
    'file_name' => 'Wikipedia_Science.png'
]);
$apperance = new AnnotationApperance([
    'width' => 100,
    'height' => 100,
    'text' => $text,
    'image' => $image
]);
$annotationArray = [
    'background_color' => new Color(['a' => 100,'r' => 0,'g' => 255,'b' => 0]),
    'contents' => 'Replace popup annotation test',
    'id' => null,
    'flags' => null,
    'name' => 'ReplacePopupAnnotation',
    'rect' => new RectangleF(['x' => 100, 'y' => 350, 'width' => 500, 'height' => 50]),
    'page_index' => 1,
    'border' => null,
    'icon' => null,
    'open' => null,
    'normal' => $apperance,
    'mouse_hover' => null,
    'pressed' => null
];
$annotation = new PopupAnnotation($annotationArray);
$apiInstance->replacePopupAnnotationByID($name, $outPath, $id, $annotation, $folder, $password);
