<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Action\GoToAction;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\LinkAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\Destination;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "ReplaceLinkAnnotationByID.pdf";
$outPath = "output/ReplaceLinkAnnotationByID.pdf";
$ids = "1-4";
$password = null;
$folder = "input";
$destArray = [
    'page_index' => 1,
    'zoom' => 1.5,
    'mode' => 'FitToPage',
    'location' => null,
    'rectangle' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 500, 'height' => 500])
];
$dest = new Destination($destArray);
$destArray = ['dest' => $dest];
$action = new GoToAction($destArray);
$annotationArray = [
    'background_color' => new Color(['a' => 100, 'r' => 0, 'g' => 255, 'b' => 0]),
    'contents' => 'link annotation test replace',
    'id' => null,
    'flags' => null,
    'name' => 'ReplaceLinkAnnotation',
    'rect' => new RectangleF(['x' => 50, 'y' => 150, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'highlight_mode' => 'NoHighlighting',
    'action_type' => 'GoToAction',
    'go_to_action' => $action,
    'embedded_go_to_action' => null,
    'javascript_action' => null,
    'launch_action' => null,
    'named_action' => null,
    'sound_action' => null,
    'uri_action' => null
];
$annotation = new LinkAnnotation($annotationArray);
$apiInstance->replaceLinkAnnotationByID($name, $outPath, $ids, $annotation, $folder, $password);