<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\FreeTextAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "ReplaceFreeTextAnnotationByID.pdf";
$outPath = "output/ReplaceFreeTextAnnotationByID.pdf";
$id = "1-2";
$password = null;
$folder = "input";
$annotationArray = [
    'background_color' => new Color(['a' => 255,'r' => 0,'g' => 255,'b' => 0]),
    'contents' => 'Replace free text annotation test',
    'id' => null,
    'flags' => null,
    'name' => 'ReplaceFreeTextAnnotation',
    'rect' => new RectangleF(['x' => 160, 'y' => 40, 'width' => 40, 'height' => 12]),
    'page_index' => 1,
    'border' => null,
    'markup_text' => 'FreeText',
    'author' => 'iceblue',
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]),
    'text_markup_color' => new Color(['a' => 100,'r' => 0,'g' => 255,'b' => 255]),
    'border_color' => null,
    'line_ending_style' => null,
    'intent' => null,
    'opacity' => 1,
    'callout_lines' => null,
    'rectangle_differences' => null,
];
$annotation = new FreeTextAnnotation($annotationArray);
$apiInstance->replaceFreeTextAnnotationByID($name, $outPath, $id, $annotation, $folder, $password);