<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperance;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperanceImage;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperanceText;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\RubberStampAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\RubberStampAnnotations;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\Font;
use Spire\Cloud\Pdf\Sdk\Model\PointF;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddRubberStampAnnotation.pdf";
$pageNumber = 1;
$password = null;
$folder = "input";
$text1 = new AnnotationApperanceText([
    'value' => "Test Normal!",
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]),
    'rect' => new RectangleF(['x' => 10, 'y' => 10, 'width' => 80, 'height' => 20]),
    'foreground_color' => null,
    'background_color' => new Color(['a' => 255, 'r' => 0, 'g' => 0, 'b' => 0]),
    'horizontal_alignment' => null,
    'vertical_alignment' => null,
    'word_wrap' => null,
    'char_spacing' => null,
    'word_spacing' => null,
    'line_spacing' => null,
    'first_line_indent' => null
]);
$text2 = new AnnotationApperanceText([
    'value' => "Test MouseHover! ",
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]),
    'rect' => new RectangleF(['x' => 10, 'y' => 10, 'width' => 80, 'height' => 20]),
    'foreground_color' => null,
    'background_color' => new Color(['a' => 255, 'r' => 0, 'g' => 0, 'b' => 0]),
    'horizontal_alignment' => null,
    'vertical_alignment' => null,
    'word_wrap' => null,
    'char_spacing' => null,
    'word_spacing' => null,
    'line_spacing' => null,
    'first_line_indent' => null
]);
$text3 = new AnnotationApperanceText([
    'value' => "Test Pressed! ",
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]),
    'rect' => new RectangleF(['x' => 10, 'y' => 10, 'width' => 80, 'height' => 20]),
    'foreground_color' => null,
    'background_color' => new Color(['a' => 255, 'r' => 0, 'g' => 0, 'b' => 0]),
    'horizontal_alignment' => null,
    'vertical_alignment' => null,
    'word_wrap' => null,
    'char_spacing' => null,
    'word_spacing' => null,
    'line_spacing' => null,
    'first_line_indent' => null
]);
$image = new AnnotationApperanceImage([
    'position' => new PointF(['x' => 50, 'y' => 50]),
    'file_name' => 'Attachment.jpg'
]);
$apperance1 = new AnnotationApperance(['width' => 100, 'height' => 100, 'text' => $text1, 'image' => $image]);
$apperance2 = new AnnotationApperance(['width' => 100, 'height' => 100, 'text' => $text2, 'image' => $image]);
$apperance3 = new AnnotationApperance(['width' => 100, 'height' => 100, 'text' => $text3, 'image' => $image]);
$annotationArray1 = [
    'background_color' => new Color(['a' => 100, 'r' => 255, 'g' => 0, 'b' => 0]),
    'contents' => 'Rubber stamp annotation test 1',
    'id' => null,
    'flags' => null,
    'name' => 'RubberStampAnnotation1',
    'rect' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 80, 'height' => 80]),
    'page_index' => 1,
    'border' => null,
    'subject' => 'RubberStamp1',
    'icon' => null,
    'normal' => null,
    'mouse_hover' => null,
    'pressed' => null
];
$annotationArray2 = [
    'background_color' => new Color(['a' => 100, 'r' => 0, 'g' => 0, 'b' => 255]),
    'contents' => 'Rubber stamp annotation test 2',
    'id' => null,
    'flags' => null,
    'name' => 'RubberStampAnnotation2',
    'rect' => new RectangleF(['x' => 50, 'y' => 350, 'width' => 100, 'height' => 100]),
    'page_index' => 1,
    'border' => null,
    'subject' => 'RubberStamp2',
    'icon' => "Additional",
    'normal' => $apperance1,
    'mouse_hover' => $apperance2,
    'pressed' => $apperance3
];
$annotation1 = new RubberStampAnnotation($annotationArray1);
$annotation2 = new RubberStampAnnotation($annotationArray2);
$rubberStampAnnotations = new RubberStampAnnotations(['list' => array($annotation1, $annotation2)]);
$apiInstance->addRubberStampAnnotation($name, $outPath, $pageNumber, $rubberStampAnnotations, $folder, $password);