<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperance;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperanceImage;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationApperanceText;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\PopupAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\PopupAnnotations;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\Font;
use Spire\Cloud\Pdf\Sdk\Model\PointF;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddPopupAnnotation.pdf";
$pageNumber = 1;
$password = null;
$folder = "output";
$text = new AnnotationApperanceText([
    'value' => "This is a test! ",
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]),
    'rect' => new RectangleF(['x' => 10, 'y' => 10, 'width' => 80, 'height' => 20]),
    'foreground_color' => null,
    'background_color' => new Color(['a' => 255, 'r' => 0, 'g' => 0, 'b' => 0]),
    'horizontal_alignment' => null,
    'vertical_alignment' => null,
    'word_wrap' => null,
    'char_spacing' => null,
    'word_spacing' => null,
    'line_spacing' => null,
    'first_line_indent' => null
]);
$image = new AnnotationApperanceImage([
    'position' => new PointF(['x' => 50, 'y' => 50]),
    'file_name' => 'Attachment.jpg'
]);
$apperance = new AnnotationApperance([
    'width' => 100,
    'height' => 100,
    'text' => $text,
    'image' => $image
]);
$annotationArray1 = [
    'background_color' => new Color(['a' => 100, 'r' => 255, 'g' => 0, 'b' => 0]),
    'contents' => 'Popup annotation test 1',
    'id' => null,
    'flags' => null,
    'name' => 'PopupAnnotation1',
    'rect' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 100, 'height' => 100]),
    'page_index' => 1,
    'border' => null,
    'icon' => null,
    'open' => null,
    'normal' => null,
    'mouse_hover' => null,
    'pressed' => null
];
$annotationArray2 = [
    'background_color' => new Color(['a' => 100, 'r' => 0, 'g' => 0, 'b' => 255]),
    'contents' => 'Popup annotation test 2',
    'id' => null,
    'flags' => null,
    'name' => 'PopupAnnotation2',
    'rect' => new RectangleF(['x' => 50, 'y' => 350, 'width' => 500, 'height' => 50]),
    'page_index' => 1,
    'border' => null,
    'icon' => null,
    'open' => null,
    'normal' => $apperance,
    'mouse_hover' => null,
    'pressed' => null
];
$annotation1 = new PopupAnnotation($annotationArray1);
$annotation2 = new PopupAnnotation($annotationArray2);
$popupAnnotations = new PopupAnnotations(['list' => array($annotation1, $annotation2)]);
$apiInstance->addPopupAnnotation($name, $outPath, $pageNumber, $popupAnnotations, $folder, $password);

