<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Action\GoToAction;
use Spire\Cloud\Pdf\Sdk\Model\Action\LaunchAction;
use Spire\Cloud\Pdf\Sdk\Model\Action\URIAction;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\LinkAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\LinkAnnotations;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\Destination;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddLinkAnnotation.pdf";
$pageNumber = 1;
$password = null;
$folder = "input";
$destArray1 = [
    'page_index' => 1,
    'zoom' => 1,
    'mode' => 'FitToPage',
    'location' => null,
    'rectangle' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 500, 'height' => 500])
];
$destArray2 = [
    'page_index' => 2,
    'zoom' => 2,
    'mode' => 'FitToPage',
    'location' => null,
    'rectangle' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 500, 'height' => 500])
];
$dest1 = new Destination($destArray1);
$dest2 = new Destination($destArray2);
$destArray1 = ['dest' => $dest1];
$destArray2 = ['dest' => $dest2];
$action1 = new GoToAction($destArray1);
$action2 = new GoToAction($destArray2);
$annotationArray1 = [
    'background_color' => new Color(['a' => 100, 'r' => 255, 'g' => 0, 'b' => 0]),
    'contents' => 'Link annotation test 1',
    'id' => null,
    'flags' => "Default",
    'name' => 'LinkAnnotation1',
    'rect' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'highlight_mode' => 'Invert',
    'action_type' => 'GoToAction',
    'go_to_action' => $action1,
    'embedded_go_to_action' => null,
    'javascript_action' => null,
    'launch_action' => null,
    'named_action' => null,
    'sound_action' => null,
    'uri_action' => null
];

$annotationArray2 = [
    'background_color' => new Color(['a' => 100, 'r' => 0, 'g' => 0, 'b' => 255]),
    'contents' => 'Link annotation test 2',
    'id' => null,
    'flags' => 'Default',
    'name' => 'LinkAnnotation2',
    'rect' => new RectangleF(['x' => 50, 'y' => 150, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'highlight_mode' => 'Outline',
    'action_type' => 'GoToAction',
    'go_to_action' => $action2,
    'embedded_go_to_action' => null,
    'javascript_action' => null,
    'launch_action' => null,
    'named_action' => null,
    'sound_action' => null,
    'uri_action' => null
];

$currentPath_pre = dirname(dirname(__FILE__));
$filename = $currentPath_pre . "\\" . "PdfDocument" . "\\" . "Image.pdf";
$action3 = new LaunchAction(['file_path' => $filename, 'new_window' => true]);
$annotationArray3 = [
    'background_color' => new Color(['a' => 100, 'r' => 0, 'g' => 255, 'b' => 0]),
    'contents' => 'Link annotation test 3 LaunchAction',
    'id' => null,
    'flags' => "Default",
    'name' => 'LinkAnnotation3',
    'rect' => new RectangleF(['x' => 50, 'y' => 300, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'highlight_mode' => 'Invert',
    'action_type' => 'LaunchAction',
    'go_to_action' => null,
    'embedded_go_to_action' => null,
    'javascript_action' => null,
    'launch_action' => $action3,
    'named_action' => null,
    'sound_action' => null,
    'uri_action' => null
];

$action4 = new URIAction(['uri' => 'https://www.baidu.com']);
$annotationArray4 = [
    'background_color' => new Color(['a' => 100, 'r' => 0, 'g' => 255, 'b' => 0]),
    'contents' => 'Link annotation test 4 URIAction',
    'id' => null,
    'flags' => "Default",
    'name' => 'LinkAnnotation4',
    'rect' => new RectangleF(['x' => 300, 'y' => 50, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'highlight_mode' => 'Invert',
    'action_type' => 'URIAction',
    'go_to_action' => null,
    'embedded_go_to_action' => null,
    'javascript_action' => null,
    'launch_action' => null,
    'named_action' => null,
    'sound_action' => null,
    'uri_action' => $action4
];

$annotation1 = new LinkAnnotation($annotationArray1);
$annotation2 = new LinkAnnotation($annotationArray2);
$annotation3 = new LinkAnnotation($annotationArray3);
$annotation4 = new LinkAnnotation($annotationArray4);
$linkAnnotations = new LinkAnnotations(['list' => array($annotation1, $annotation2, $annotation3, $annotation4)]);
$apiInstance->addLinkAnnotation($name, $outPath, $pageNumber, $linkAnnotations, $folder, $password);
