<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\LineAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\LineAnnotations;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\PointF;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddLineAnnotation.pdf";
$pageNumber = 1;
$password = null;
$folder = "input";
$annotationArray1 = [
    'background_color' => new Color(['a' => 100, 'r' => 255, 'g' => 0, 'b' => 0]),
    'contents' => 'Line annotation test 1',
    'id' => null,
    'flags' => null,
    'name' => 'LineAnnotation1',
    'rect' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 500, 'height' => 50]),
    'page_index' => null,
    'starting' => new PointF(['x' => 60, 'y' => 60]),
    'ending' => new PointF(['x' => 500, 'y' => 60]),
    'border' => null,
    'line_caption' => null,
    'leader_line' => 0,
    'leader_line_ext' => 0,
    'line_border' => null,
    'inner_line_color' => null,
    'starting_style' => null,
    'ending_style' => null,
    'caption_type' => null,
    'intent' => null
];
$annotationArray2 = [
    'background_color' => new Color(['a' => 100, 'r' => 0, 'g' => 0, 'b' => 255]),
    'contents' => 'Line annotation test 2',
    'id' => null,
    'flags' => null,
    'name' => 'LineAnnotation2',
    'rect' => new RectangleF(['x' => 50, 'y' => 350, 'width' => 500, 'height' => 50]),
    'page_index' => null,
    'starting' => new PointF(['x' => 60, 'y' => 360]),
    'ending' => new PointF(['x' => 500, 'y' => 360]),
    'border' => null,
    'line_caption' => null,
    'leader_line' => 0,
    'leader_line_ext' => 0,
    'line_border' => null,
    'inner_line_color' => null,
    'starting_style' => null,
    'ending_style' => null,
    'caption_type' => null,
    'intent' => null
];
$annotation1 = new LineAnnotation($annotationArray1);
$annotation2 = new LineAnnotation($annotationArray2);
$lineAnnotations = new LineAnnotations(['list' => array($annotation1, $annotation2)]);
$apiInstance->addLineAnnotation($name, $outPath, $pageNumber, $lineAnnotations, $folder, $password);