<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\AnnotationBorder;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\FreeTextAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\FreeTextAnnotations;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\Font;
use Spire\Cloud\Pdf\Sdk\Model\PointF;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddFreeTextAnnotation.pdf";
$pageNumber = 1;
$password = null;
$folder = "input";
$border1 = new AnnotationBorder(['width' => 0.5, 'horizontal_radius' => 0, 'vertical_radius' => 0]);
$border2 = new AnnotationBorder(['width' => 5, 'horizontal_radius' => 2, 'vertical_radius' => 2]);
$point1 = new PointF(['x' => 150, 'y' => 50]);
$point2 = new PointF(['x' => 155, 'y' => 45]);
$point3 = new PointF(['x' => 160, 'y' => 40]);
$annotationArray1 = [
    'background_color' => new Color(['a' => 255, 'r' => 225, 'g' => 225, 'b' => 255]),
    'contents' => 'Free text annotation test 1',
    'id' => null,
    'flags' => "Invisible",
    'name' => 'FreeTextAnnotation1',
    'rect' => new RectangleF(['x' => 160, 'y' => 40, 'width' => 40, 'height' => 12]),
    'page_index' => 1,
    'border' => $border1,
    'author' => 'E-iceblue',
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 8, 'font_style' => "Italic"]),
    'text_markup_color' => new Color(['a' => 1, 'r' => 65, 'g' => 105, 'b' => 225]),
    'border_color' => new Color(['a' => 255, 'r' => 0, 'g' => 0, 'b' => 0]),
    'line_ending_style' => null,
    'intent' => null,
    'opacity' => 0.7,
    'callout_lines' => array($point1, $point2, $point3),
    'rectangle_differences' => null,
];
$annotationArray2 = [
    'background_color' => new Color(['a' => 255, 'r' => 245, 'g' => 222, 'b' => 179]),
    'contents' => 'Free text annotation test 2',
    'id' => null,
    'flags' => "Invisible",
    'name' => 'FreeTextAnnotation2',
    'rect' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 100, 'height' => 100]),
    'page_index' => 1,
    'border' => $border2,
    'author' => 'E-iceblue',
    'font' => new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Bold"]),
    'text_markup_color' => new Color(['a' => 100, 'r' => 0, 'g' => 255, 'b' => 0]),
    'border_color' => new Color(['a' => 255, 'r' => 0, 'g' => 0, 'b' => 0]),
    'line_ending_style' => 'Slash',
    'intent' => 'FreeTextTypeWriter',
    'opacity' => 1,
    'callout_lines' => null,
    'rectangle_differences' => array(20, 20, 5, 5),
];
$annotation1 = new FreeTextAnnotation($annotationArray1);
$annotation2 = new FreeTextAnnotation($annotationArray2);
$annotations = new FreeTextAnnotations(['list' => array($annotation1, $annotation2)]);
$apiInstance->addFreeTextAnnotation($name, $outPath, $pageNumber, $annotations, $folder, $password);
