<?php

use Spire\Cloud\Pdf\Sdk\Api\PdfAnnotationApi;
use Spire\Cloud\Pdf\Sdk\Configuration;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\FileAttachmentAnnotation;
use Spire\Cloud\Pdf\Sdk\Model\Annotation\FileAttachmentAnnotations;
use Spire\Cloud\Pdf\Sdk\Model\Color;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

$appId = "your id";
$appKey = "your key";
$baseUrl = "https://api.e-iceblue.cn";
$configuration = new Configuration($appId, $appKey, $baseUrl);
$apiInstance = new PdfAnnotationApi($configuration);

$name = "Sample.pdf";
$outPath = "output/AddFileAttachmentAnnotation.pdf";
$pageNumber = 1;
$password = null;
$folder = "input";
$annotationArray1 = [
    'background_color' => new Color(['a' => 100, 'r' => 255, 'g' => 0, 'b' => 0]),
    'contents' => 'File attachment annotation test 1',
    'id' => null,
    'flags' => null,
    'name' => 'FileAttachmentAnnotation1',
    'rect' => new RectangleF(['x' => 50, 'y' => 50, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'icon' => null,
    'file_name' => 'Sample.xps'
];
$annotationArray2 = [
    'background_color' => new Color(['a' => 100, 'r' => 0, 'g' => 0, 'b' => 255]),
    'contents' => 'File attachment annotation test 2',
    'id' => null,
    'flags' => null,
    'name' => 'FileAttachmentAnnotation2',
    'rect' => new RectangleF(['x' => 50, 'y' => 150, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'icon' => null,
    'file_name' => 'Sample.txt'
];
$annotationArray3 = [
    'background_color' => new Color(['a' => 1, 'r' => 255, 'g' => 182, 'b' => 193]),
    'contents' => 'File attachment annotation test 3',
    'id' => null,
    'flags' => null,
    'name' => 'FileAttachmentAnnotation3',
    'rect' => new RectangleF(['x' => 50, 'y' => 250, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'icon' => null,
    'file_name' => 'Image.pdf'
];
$annotationArray4 = [
    'background_color' => new Color(['a' => 1, 'r' => 238, 'g' => 130, 'b' => 238]),
    'contents' => 'File attachment annotation test 4',
    'id' => null,
    'flags' => null,
    'name' => 'FileAttachmentAnnotation2',
    'rect' => new RectangleF(['x' => 50, 'y' => 350, 'width' => 50, 'height' => 50]),
    'page_index' => null,
    'border' => null,
    'icon' => null,
    'file_name' => 'Attachment.jpg'
];
$annotation1 = new FileAttachmentAnnotation($annotationArray1);
$annotation2 = new FileAttachmentAnnotation($annotationArray2);
$annotation3 = new FileAttachmentAnnotation($annotationArray3);
$annotation4 = new FileAttachmentAnnotation($annotationArray4);
$annotations = new FileAttachmentAnnotations(['list' => array($annotation1, $annotation2, $annotation3, $annotation4)]);
$apiInstance->addFileAttachmentAnnotation($name, $outPath, $pageNumber, $annotations, $folder, $password);
