<?php

/**
 * Copyright(c) 2012-2020 E-ICEBLUE Spire.Cloud.Pdf
 * 
 * This program is a free software product. You can redistribute it and/or modify it under the 
 * terms of the GNU Affero General Public License (AGPL) version 3 as published by the Free 
 * Software Foundation, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to 
 * whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED,INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY,WHETHER IN AN ACTION OF ONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER EALINGS IN THE 
 * SOFTWARE.
 */

namespace Spire\Cloud\Pdf\Sdk\Test\TestHelper;

use Spire\Cloud\Pdf\Sdk\Model\AcroForm\TextBoxField;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;
use Spire\Cloud\Pdf\Sdk\Model\Color;

/**
 * TextBoxHelper Class table test helper
 *
 * @category Class
 * @package  Spire\Cloud\Pdf\Sdk\Test\TestHelper\TextBoxHelper
 * @author   E-ICEBLUE
 */
class TextBoxHelper
{
    public function GetTextBoxField($testType)
    {
        switch ($testType) {
            case  "Required":
                return $this->SimpleTextBoxField();

            case  "MappingName":
                return $this->MappingNameTextBoxField();

            case  "ToolTip":
                return $this->ToolTipTextBoxField();

            case  "Value":
                return $this->ValuesTextBoxField();

            case  "ForeColor":
                return $this->ForeColorTextBoxField();

            case  "DefaultValue":
                return $this->DefaultValueTextBoxField();

            case  "MaxLength":
                return $this->MaxLengthTextBoxField();

            case  "HighlightMode":
                return $this->HighlightModeTextBoxField();

            case  "TextAlignment":
                return $this->TextAlignmentTextBoxField();
        }
        return null;
    }


    private function SimpleTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        return $TextBox;
    }
    private function MappingNameTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        $TextBox->setMappingName("TextBoxMapingName");
        return $TextBox;
    }

    private function ToolTipTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        $TextBox->setMappingName("TextBoxMapingName");
        $TextBox->setToolTip("TextBoxToolTip");
        return $TextBox;
    }
    private function ValuesTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        $TextBox->setMappingName("TextBoxMapingName");
        $TextBox->setToolTip("TextBoxToolTip");
        $TextBox->setValue("textBoxNewLineText");
        return $TextBox;
    }

    private function TextAlignmentTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        $TextBox->setMappingName("TextBoxMapingName");
        $TextBox->setToolTip("TextBoxToolTip");
        $TextBox->setValue("textBoxNewLineText");
        $TextBox->setTextAlignment("Center");
        return $TextBox;
    }

    private function HighlightModeTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        $TextBox->setMappingName("TextBoxMapingName");
        $TextBox->setToolTip("TextBoxToolTip");
        $TextBox->setValue("textBoxNewLineText");
        $TextBox->setTextAlignment("Center");
        $TextBox->setHighlightMode("NoHighlighting");
        return $TextBox;
    }

    private function MaxLengthTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        $TextBox->setMappingName("TextBoxMapingName");
        $TextBox->setToolTip("TextBoxToolTip");
        $TextBox->setValue("textBoxNewLineText");
        $TextBox->setTextAlignment("Center");
        $TextBox->setHighlightMode("NoHighlighting");
        $TextBox->setMaxLength(250);
        return $TextBox;
    }

    private function DefaultValueTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        $TextBox->setMappingName("TextBoxMapingName");
        $TextBox->setToolTip("TextBoxToolTip");
        $TextBox->setValue("textBoxNewLineText");
        $TextBox->setTextAlignment("Center");
        $TextBox->setHighlightMode("NoHighlighting");
        $TextBox->setMaxLength(250);
        $TextBox->setDefaultValue("DefaultValue");
        return $TextBox;
    }

    private function ForeColorTextBoxField()
    {
        $TextBox = $this->SetRequiredProperties();
        $TextBox->setMappingName("TextBoxMapingName");
        $TextBox->setToolTip("TextBoxToolTip");
        $TextBox->setValue("textBoxNewLineTexttextBoxNewLineTexttextBoxNewLineTexttextBoxNewLineTexttextBoxNewLineTexttextBoxNewLineTexttextBoxNewLineText");
        $TextBox->setTextAlignment("Center");
        $TextBox->setHighlightMode("NoHighlighting");
        $TextBox->setMaxLength(250);
        $TextBox->setDefaultValue("DefaultValue");
        $TextBox->setForeColor(new Color(['a' => 255, 'r' => 110, 'g' => 110, 'b' => 110]));
        return $TextBox;
    }
    private function SetRequiredProperties()
    {
        $TextBoxFlags = array();
        $TextBoxFlags[] = "NoExport";
        $TextBoxFlags[] = "Multiline";
        $TextBoxFlags[] = "DoNotSpellCheck";

        $Bounds = new RectangleF(['x' => 300, 'y' => 500, 'width' => 150, 'height' => 80]);
        $Name = "fax";
        $PageIndex = 1;

        return new TextBoxField(['text_box_flags' => $TextBoxFlags, 'name' => $Name, 'page_index' => $PageIndex, 'bounds' => $Bounds]);
    }
}
