<?php

/**
 * Copyright(c) 2012-2020 E-ICEBLUE Spire.Cloud.Pdf
 * 
 * This program is a free software product. You can redistribute it and/or modify it under the 
 * terms of the GNU Affero General Public License (AGPL) version 3 as published by the Free 
 * Software Foundation, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to 
 * whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED,INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY,WHETHER IN AN ACTION OF ONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER EALINGS IN THE 
 * SOFTWARE.
 */

namespace Spire\Cloud\Pdf\Sdk\Test\TestHelper;

use \Spire\Cloud\Pdf\Sdk\Model\Table\Table;
use \Spire\Cloud\Pdf\Sdk\Model\Table\TableBorder;
use \Spire\Cloud\Pdf\Sdk\Model\Table\TableCell;
use \Spire\Cloud\Pdf\Sdk\Model\Table\TableColumn;
use \Spire\Cloud\Pdf\Sdk\Model\Table\TableRow;
use Spire\Cloud\Pdf\Sdk\Model\Table\TextElement;
use Spire\Cloud\Pdf\Sdk\Model\PointF;
use Spire\Cloud\Pdf\Sdk\Model\StringFormat;
use Spire\Cloud\Pdf\Sdk\Model\Font;
use Spire\Cloud\Pdf\Sdk\Model\Color;



/**
 * TableTestHelper Class table test helper
 *
 * @category Class
 * @package  Spire\Cloud\Pdf\Sdk\Test\TableTestHelper
 * @author   E-ICEBLUE
 */
class TableTestHelper
{
    /**
     * GetTable
     * 
     * get table
     * 
     *  @param
     */
    public function GetTable($testtype)
    {
        $Testtype = $testtype;
        switch ($Testtype) {
            case "TestRequiredItem":
                return $this->CreateRequiredItemsTable();

            case "GlobalTextAlignment":
                return $this->CreateGlobalStringFormatTable($Testtype);
            case "GlobalVerticalAlignment":
                return $this->CreateGlobalStringFormatTable($Testtype);
            case "GlobalCharaSpace":
                return $this->CreateGlobalStringFormatTable($Testtype);
            case "GlobalWordSpace":
                return $this->CreateGlobalStringFormatTable($Testtype);

            case "Font":
                return $this->CreateTableByCellStyle($Testtype);
            case "TextBackGroundColor":
                return $this->CreateTableByCellStyle($Testtype);
            case "TextForeGroundColor":
                return $this->CreateTableByCellStyle($Testtype);
            case "LocalTextAlignment":
                return $this->CreateTableByCellStyle($Testtype);
            case "LocalVerticalAlignment":
                return $this->CreateTableByCellStyle($Testtype);
            case "LocalCharaSpace":
                return $this->CreateTableByCellStyle($Testtype);
            case "LocalWordSpace":
                return $this->CreateTableByCellStyle($Testtype);
            case "CellBorder":
                return $this->CreateTableByCellStyle($Testtype);
            case "CellBackGroundColor":
                return $this->CreateTableByCellStyle($Testtype);

            case "RowSpan":
                return  $this->CreateTableOfSpan($Testtype);
            case "ColumnSpan":
                return $this->CreateTableOfSpan($Testtype);

            case "TableHeader":
                return  $this->CreateTableOfHeader($Testtype);
        }
    }

    private function CreateRequiredItemsTable()
    {
        $rowsitem = array(
            array("China", "960", "14", "Asian", "Panda"),
            array("America", "937", "3.27", "South America", "Haliaeetus leucocephalus")
        );
        $rowlist =  array();
        $row = null;

        for ($i = 0; $i < 2; $i++) {
            $cell = null;
            $celllist = array();

            for ($j = 0; $j < 5; $j++) {
                $textElement = new TextElement(['text' => $rowsitem[$i][$j]]);
                $cell = new TableCell(['text_element' => $textElement]);
                $celllist[] = $cell;
            }

            $row = new TableRow(['height' => 40, 'table_cells' => $celllist]);
            $rowlist[] = $row;
        }

        $columnlist = array();
        $column = null;

        for ($i = 0; $i < 5; $i++) {
            $column = new TableColumn(['width' => 80 + 5 * $i]);
            $columnlist[] = $column;
        }

        $table = new Table(['location' => new PointF(['x' => 30, 'y' => 250]), 'table_header' => null, 'table_rows' => $rowlist, 'table_columns' => $columnlist]);
        return $table;
    }

    private function CreateGlobalStringFormatTable($Testtype)
    {
        $rowsitem = array(
            array("China", "960", "14", "Asian", "Panda"),
            array("America", "937", "3.27", "South America", "Haliaeetus leucocephalus")
        );
        $rowlist =  array();
        $row = null;

        for ($i = 0; $i < 2; $i++) {
            $cell = null;
            $celllist = array();

            for ($j = 0; $j < 5; $j++) {
                $textElement = new TextElement(['text' => $rowsitem[$i][$j]]);
                $cell = new TableCell(['text_element' => $textElement]);
                $celllist[] = $cell;
            }

            $row = new TableRow(['height' => 40, 'table_cells' => $celllist]);
            $rowlist[] = $row;
        }

        $columnlist = array();
        $column = null;

        for ($i = 0; $i < 5; $i++) {
            $column = new TableColumn(['width' => 80 + 5 * $i]);
            $stringformat = new StringFormat();

            if ($Testtype == "GlobalTextAlignment") {
                $stringformat->setTextAlignment("Center");
            }
            if ($Testtype == "GlobalVerticalAlignment") {
                $stringformat->setTextAlignment("Center");
                $stringformat->setVerticalAlignment("Middle");
            }
            if ($Testtype == "GlobalCharaSpace") {
                $stringformat->setTextAlignment("Center");
                $stringformat->setVerticalAlignment("Middle");
                $stringformat->setCharacterSpacing(0.5);
            }
            if ($Testtype == "GlobalWordSpace") {
                $stringformat->setTextAlignment("Center");
                $stringformat->setVerticalAlignment("Middle");
                $stringformat->setCharacterSpacing(0.5);
                $stringformat->setWordSpacing(5);
            }

            $column->setStringFormat($stringformat);
            $columnlist[] = $column;
        }

        $table = new Table(['location' => new PointF(['x' => 30, 'y' => 250]), 'table_header' => null, 'table_rows' => $rowlist, 'table_columns' => $columnlist]);
        return $table;
    }

    private function CreateTableByCellStyle($Testtype)
    {
        $rowsitem = array(
            array("China", "960", "14", "Asian", "Panda"),
            array("America", "937", "3.27", "South America", "Haliaeetus leucocephalus")
        );
        $rowlist = array();
        $row = null;
        for ($i = 0; $i < 2; $i++) {
            $cell = null;
            $celllist = array();
            for ($j = 0; $j < 5; $j++) {
                $textElement = new TextElement(['text' => $rowsitem[$i][$j]]);
                $font = new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Regular"]);
                $textForeGroundColor = new Color(['a' => 10, 'r' => 255, 'g' => 0, 'b' => 0]);
                $textBackGrounColor = new Color(['a' => 10, 'r' => 70, 'g' => 125, 'b' => 170]);
                $stringFormat = new StringFormat();

                if ($Testtype == "Font") {
                    $textElement->setFont($font);
                }
                if ($Testtype == "TextBackGroundColor") {
                    $textElement->setFont($font);
                    $textElement->setBackGroundColor($textBackGrounColor);
                }
                if ($Testtype == "TextForeGroundColor") {
                    $textElement->setFont($font);
                    $textElement->setBackGroundColor($textBackGrounColor);
                    $textElement->setForeGroundColor($textForeGroundColor);
                }
                if ($Testtype == "LocalTextAlignment") {
                    $textElement->setFont($font);
                    $textElement->setBackGroundColor($textBackGrounColor);
                    $textElement->setForeGroundColor($textForeGroundColor);
                    $stringFormat->setTextAlignment("Center");
                }
                if ($Testtype == "LocalVerticalAlignment") {
                    $textElement->setFont($font);
                    $textElement->setBackGroundColor($textBackGrounColor);
                    $textElement->setForeGroundColor($textForeGroundColor);
                    $stringFormat->setTextAlignment("Center");
                    $stringFormat->setVerticalAlignment("Middle");
                }
                if ($Testtype == "LocalCharaSpace") {
                    $textElement->setFont($font);
                    $textElement->setBackGroundColor($textBackGrounColor);
                    $textElement->setForeGroundColor($textForeGroundColor);
                    $stringFormat->setTextAlignment("Center");
                    $stringFormat->setVerticalAlignment("Middle");
                    $stringFormat->setCharacterSpacing(0.5);
                }
                if ($Testtype == "LocalWordSpace") {
                    $textElement->setFont($font);
                    $textElement->setBackGroundColor($textBackGrounColor);
                    $textElement->setForeGroundColor($textForeGroundColor);
                    $stringFormat->setTextAlignment("Center");
                    $stringFormat->setVerticalAlignment("Middle");
                    $stringFormat->setCharacterSpacing(0.5);
                    $stringFormat->setWordSpacing(5);
                }
                if ($Testtype == "CellBorder" || $Testtype == "CellBackGroundColor") {
                    $textElement->setFont($font);
                    $textElement->setBackGroundColor($textBackGrounColor);
                    $textElement->setForeGroundColor($textForeGroundColor);
                    $stringFormat->setTextAlignment("Center");
                    $stringFormat->setVerticalAlignment("Middle");
                    $stringFormat->setCharacterSpacing(0.5);
                    $stringFormat->setWordSpacing(5);
                }
                $textElement->setStringFormat($stringFormat);
                $cell = new TableCell(['text_element' => $textElement]);
                if ($Testtype == "CellBorder") {
                    $tableBorder = new TableBorder(['border_color' => new Color(['a' => 15, 'r' => 25, 'g' => 25, 'b' => 100]), 'border_width' => 1.5]);
                    $cell->setTableBorder($tableBorder);
                }
                if ($Testtype == "CellBackGroundColor") {
                    $tableBorder = new TableBorder(['border_color' => new Color(['a' => 15, 'r' => 25, 'g' => 25, 'b' => 100]), 'border_width' => 1.5]);
                    $cellBackGroundColor = new Color(['a' => 15, 'r' => 230, 'g' => 230, 'b' => 230]);
                    $cell->setTableBorder($tableBorder);
                    $cell->setBackGroundColor($cellBackGroundColor);
                }
                $celllist[] = $cell;
            }

            $row = new TableRow(['height' => 40, 'table_cells' => $celllist]);
            $rowlist[] = $row;
        }

        $columnlist = array();
        $column = null;
        for ($i = 0; $i < 5; $i++) {
            $column = new TableColumn(['width' => 80 + 5 * $i]);
            $columnlist[] = $column;
        }

        $table = new Table(['location' => new PointF(['x' => 30, 'y' => 250]), 'table_header' => null, 'table_rows' => $rowlist, 'table_columns' => $columnlist]);
        return $table;
    }

    private function CreateTableOfSpan($Testtype)
    {
        $rowsitem = array(
            array("China", "960", "14", "Asian", "Panda"),
            array("Japanese", "37.8", "1.27", "Asian", "Crested Ibis")
        );
        $rowlist = array();
        $row = null;
        for ($i = 0; $i < 2; $i++) {
            $cell = null;
            $celllist = array();
            for ($j = 0; $j < 5; $j++) {
                $textElement = new TextElement(['text' => $rowsitem[$i][$j]]);
                $font = new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Regular"]);
                $textForeGroundColor = new Color(['a' => 10, 'r' => 255, 'g' => 0, 'b' => 0]);
                $textBackGrounColor = new Color(['a' => 10, 'r' => 70, 'g' => 125, 'b' => 170]);
                $stringFormat = new StringFormat();

                $textElement->setFont($font);
                $textElement->setBackGroundColor($textBackGrounColor);
                $textElement->setForeGroundColor($textForeGroundColor);
                $stringFormat->setTextAlignment("Center");
                $stringFormat->setVerticalAlignment("Middle");
                $stringFormat->setCharacterSpacing(0.5);
                $stringFormat->setWordSpacing(5);
                $textElement->setStringFormat($stringFormat);

                $cell = new TableCell(['text_element' => $textElement]);
                $tableBorder = new TableBorder(['border_color' => new Color(['a' => 15, 'r' => 25, 'g' => 25, 'b' => 100]), 'border_width' => 1.5]);
                $cellBackGroundColor = new Color(['a' => 15, 'r' => 230, 'g' => 230, 'b' => 230]);
                $cell->setTableBorder($tableBorder);
                $cell->setBackGroundColor($cellBackGroundColor);

                if ($Testtype == "RowSpan" && $i == 0 && $j == 3) {
                    $cell->setRowSpan(2);
                }
                if ($Testtype == "ColumnSpan" && $i == 0 && $j == 1) {
                    $cell->setColumnSpan(2);
                    $cell->getTextElement()->setText("vast territory and abundant resources");
                }
                $celllist[] = $cell;
            }

            $row = new TableRow(['height' => 40, 'table_cells' => $celllist]);
            $rowlist[] = $row;
        }

        $columnlist = array();
        $column = null;
        for ($i = 0; $i < 5; $i++) {
            $column = new TableColumn(['width' => 80 + 5 * $i]);
            $columnlist[] = $column;
        }

        $table = new Table(['location' => new PointF(['x' => 30, 'y' => 250]), 'table_header' => null, 'table_rows' => $rowlist, 'table_columns' => $columnlist]);
        return $table;
    }

    private function CreateTableOfHeader($Testtype)
    {
        $headerItems = array(
            "Country", "Area", "Population", "geography", "NationalTreasure"
        );
        $rowsitem = array(
            array("China", "960", "14", "Asian", "Panda"),
            array("Japanese", "37.8", "1.27", "Asian", "Crested Ibis")
        );

        $header = null;
        $headerCell = null;
        $headerCelllist = array();

        for ($j = 0; $j < 5; $j++) {
            $textElement = new TextElement(['text' => $headerItems[$j]]);
            $font = new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Regular"]);
            $textForeGroundColor = new Color(['a' => 10, 'r' => 255, 'g' => 0, 'b' => 0]);
            $textBackGrounColor = new Color(['a' => 10, 'r' => 70, 'g' => 125, 'b' => 170]);
            $stringFormat = new StringFormat();

            $textElement->setFont($font);
            $textElement->setBackGroundColor($textBackGrounColor);
            $textElement->setForeGroundColor($textForeGroundColor);
            $stringFormat->setTextAlignment("Center");
            $stringFormat->setVerticalAlignment("Middle");
            $stringFormat->setCharacterSpacing(0.5);
            $stringFormat->setWordSpacing(5);
            $textElement->setStringFormat($stringFormat);

            $headerCell = new TableCell(['text_element' => $textElement]);
            $tableBorder = new TableBorder(['border_color' => new Color(['a' => 15, 'r' => 25, 'g' => 25, 'b' => 100]), 'border_width' => 1.5]);
            $cellBackGroundColor = new Color(['a' => 15, 'r' => 230, 'g' => 230, 'b' => 230]);
            $headerCell->setTableBorder($tableBorder);
            $headerCell->setBackGroundColor($cellBackGroundColor);
            $headerCelllist[] = $headerCell;
        }

        $header = new TableRow(['height' => 40, 'table_cells' => $headerCelllist]);
        $rowlist = array();
        $row = null;

        for ($i = 0; $i < 2; $i++) {
            $cell = null;
            $celllist = array();

            for ($j = 0; $j < 5; $j++) {
                $textElement = new TextElement(['text' => $rowsitem[$i][$j]]);
                $font = new Font(['font_type' => "Standard", 'font_family' => "Helvetica", 'font_size' => 12, 'font_style' => "Regular"]);
                $textForeGroundColor = new Color(['a' => 10, 'r' => 255, 'g' => 0, 'b' => 0]);
                $textBackGrounColor = new Color(['a' => 10, 'r' => 70, 'g' => 125, 'b' => 170]);
                $stringFormat = new StringFormat();

                $textElement->setFont($font);
                $textElement->setBackGroundColor($textBackGrounColor);
                $textElement->setForeGroundColor($textForeGroundColor);
                $stringFormat->setTextAlignment("Center");
                $stringFormat->setVerticalAlignment("Middle");
                $stringFormat->setCharacterSpacing(0.5);
                $stringFormat->setWordSpacing(5);
                $textElement->setStringFormat($stringFormat);

                $cell = new TableCell(['text_element' => $textElement]);
                $tableBorder = new TableBorder(['border_color' => new Color(['a' => 15, 'r' => 25, 'g' => 25, 'b' => 100]), 'border_width' => 1.5]);
                $cellBackGroundColor = new Color(['a' => 15, 'r' => 230, 'g' => 230, 'b' => 230]);
                $cell->setTableBorder($tableBorder);
                $cell->setBackGroundColor($cellBackGroundColor);

                if ($i == 0 && $j == 3) {
                    $cell->setRowSpan(2);
                }
                if ($i == 0 && $j == 1) {
                    $cell->setColumnSpan(2);
                    $cell->getTextElement()->setText("vast territory and abundant resources");
                }
                $celllist[] = $cell;
            }
            $row = new TableRow(['height' => 40, 'table_cells' => $celllist]);
            $rowlist[] = $row;
        }

        $columnlist = array();
        $column = null;
        for ($i = 0; $i < 5; $i++) {
            $column = new TableColumn(['width' => 80 + 8 * $i]);
            $columnlist[] = $column;
        }
        $table = new Table([new PointF(['x' => 30, 'y' => 250]), $header, $rowlist, $columnlist]);
        $table = new Table(['location' => new PointF(['x' => 30, 'y' => 250]), 'table_header' => $header, 'table_rows' => $rowlist, 'table_columns' => $columnlist]);
        return $table;
    }
}
