<?php

/**
 * Copyright(c) 2012-2020 E-ICEBLUE Spire.Cloud.Pdf
 * 
 * This program is a free software product. You can redistribute it and/or modify it under the 
 * terms of the GNU Affero General Public License (AGPL) version 3 as published by the Free 
 * Software Foundation, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to 
 * whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED,INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY,WHETHER IN AN ACTION OF ONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER EALINGS IN THE 
 * SOFTWARE.
 */

namespace Spire\Cloud\Pdf\Sdk\Test\TestHelper;

use Spire\Cloud\Pdf\Sdk\Model\AcroForm\RadioButtonField;
use Spire\Cloud\Pdf\Sdk\Model\AcroForm\RadioButtonOptionField;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;


/**
 * RadioButtonHelper Class table test helper
 *
 * @category Class
 * @package  Spire\Cloud\Pdf\Sdk\Test\TestHelper\RadioButtonHelper
 * @author   E-ICEBLUE
 */
class RadioButtonHelper
{
    public function GetRadioButtonField($testType)
    {
        switch ($testType) {
            case  "Required":
                return $this->SimpleRadioButtonField();

            case  "MappingName":
                return $this->MappingNameRadioButtonField();

            case  "ToolTip":
                return $this->ToolTipRadioButtonField();

            case  "SelectedIndexs":
                return $this->SelectedIndexsRadioButtonField();
        }
        return null;
    }

    private function SimpleRadioButtonField()
    {
        $RadioButton = $this->SetRequiredProperties();
        $values = array("PDF", "XLS", "PPT");
        $RadioButton->setValues ($values);
        return $RadioButton;
    }
    private function MappingNameRadioButtonField()
    {
        $RadioButton = $this->SetRequiredProperties();
        $RadioButton->setMappingName("RadioButtonMapingName");
        $values = array("PDF", "XLS", "PPT");
        $RadioButton->setValues ($values);
        return $RadioButton;
    }

    private function ToolTipRadioButtonField()
    {
        $RadioButton = $this->SetRequiredProperties();
        $RadioButton->setMappingName("RadioButtonMapingName");
        $RadioButton->setToolTip  ("RadioButtonToolTip");
        $values = array("PDF", "XLS", "PPT");
        $RadioButton->setValues ($values);
        return $RadioButton;
    }

    private function SelectedIndexsRadioButtonField()
    {
        $RadioButton = $this->SetRequiredProperties();
        $RadioButton->setMappingName("RadioButtonMapingName");
        $RadioButton->setToolTip  ("RadioButtonToolTip");
        $values = array("PDF", "XLS", "PPT");
        $RadioButton->setValues ($values);
        $RadioButton->setSelectedIndex (1);
        return $RadioButton;
    }
    private function SetRequiredProperties()
    {
        $RadioButtonFlags = array();
        $RadioButtonFlags[] = "NoExport";
        $RadioButtonFlags[] = "Required";

        $Name = "country";
        $PageIndex = 1;

        $Value = "";
        $Bounds = null;
        $RrdioButtonOptionField = null;
        $values = array("PDF", "XLS", "PPT");
        $options = array();

        for ($i = 0; $i < 3; $i++) {
            $Bounds = new RectangleF(['x' => 300 + 20 * $i, 'y' => 500, 'width' => 10, 'height' => 10]);
            $Value = $values[$i];
            $RrdioButtonOptionField = new RadioButtonOptionField(['bounds' => $Bounds, 'value' => $Value]);
            $options[] = $RrdioButtonOptionField;
        }
        return new RadioButtonField(['page_index' => $PageIndex, 'radio_button_flags' => $RadioButtonFlags, 'name' => $Name, 'radio_button_option_fields' => $options]);
    }
}
