<?php

/**
 * Copyright(c) 2012-2020 E-ICEBLUE Spire.Cloud.Pdf
 * 
 * This program is a free software product. You can redistribute it and/or modify it under the 
 * terms of the GNU Affero General Public License (AGPL) version 3 as published by the Free 
 * Software Foundation, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to 
 * whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED,INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY,WHETHER IN AN ACTION OF ONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER EALINGS IN THE 
 * SOFTWARE.
 */

namespace Spire\Cloud\Pdf\Sdk\Test\TestHelper;

use Spire\Cloud\Pdf\Sdk\Model\AcroForm\PushButtonField;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;


/**
 * PushButtonHelper Class table test helper
 *
 * @category Class
 * @package  Spire\Cloud\Pdf\Sdk\Test\TestHelper\PushButtonHelper
 * @author   E-ICEBLUE
 */
class PushButtonHelper
{
    public function GetPushButtonField($testType)
    {
        switch ($testType) {
            case  "Required":
                return $this->SimplePushButtonField();

            case  "MappingName":
                return $this->MappingNamePushButtonField();

            case  "ToolTip":
                return $this->ToolTipPushButtonField();

            case  "Values":
                return $this->ValuesPushButtonField();
        }
        return null;
    }

    private function SimplePushButtonField()
    {
        $PushButton = $this->SetRequiredProperties();
        return $PushButton;
    }
    private function MappingNamePushButtonField()
    {
        $PushButton = $this->SetRequiredProperties();
        $PushButton->setMappingName("PushButtonMapingName");
        return $PushButton;
    }

    private function ToolTipPushButtonField()
    {
        $PushButton = $this->SetRequiredProperties();
        $PushButton->setMappingName("PushButtonMapingName");
        $PushButton->setToolTip ("PushButtonToolTip");
        return $PushButton;
    }
    private function ValuesPushButtonField()
    {
        $PushButton = $this->SetRequiredProperties();
        $PushButton->setMappingName("PushButtonMapingName");
        $PushButton->setToolTip ("PushButtonToolTip");
        $PushButton->setValue ("Push It");
        return $PushButton;
    }
    private function SetRequiredProperties()
    {
        $PushButtonFlags = array();
        $PushButtonFlags[] = "NoExport";
        $PushButtonFlags[] = "Required";

        $Bounds = new RectangleF(['x' => 300, 'y' => 500, 'width' => 50, 'height' => 25]);
        $Name = "submit";
        $PageIndex = 1;

        return new PushButtonField(['push_button_flags' => $PushButtonFlags, 'name' => $Name, 'page_index' => $PageIndex, 'bounds' => $Bounds]);
    }
}
