<?php

/**
 * Copyright(c) 2012-2020 E-ICEBLUE Spire.Cloud.Pdf
 * 
 * This program is a free software product. You can redistribute it and/or modify it under the 
 * terms of the GNU Affero General Public License (AGPL) version 3 as published by the Free 
 * Software Foundation, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to 
 * whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED,INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY,WHETHER IN AN ACTION OF ONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER EALINGS IN THE 
 * SOFTWARE.
 */

namespace Spire\Cloud\Pdf\Sdk\Test\TestHelper;

use Spire\Cloud\Pdf\Sdk\Model\AcroForm\ListBoxField;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

/**
 * ListBoxHelper Class table test helper
 *
 * @category Class
 * @package  Spire\Cloud\Pdf\Sdk\Test\TestHelper\ListBoxHelper
 * @author   E-ICEBLUE
 */
class ListBoxHelper
{
    public function GetListBoxField($testType)
    {
        switch ($testType) {
            case  "Required":
                return $this->SimpleListBoxField();

            case  "MappingName":
                return $this->MappingNameListBoxField();

            case  "SelectedIndexs":
                return $this->SelectedIndexsListBoxField();

            case  "ToolTip":
                return $this->ToolTipListBoxField();

            case  "Values":
                return $this->ValuesListBoxField();
        }
        return null;
    }

    private function SimpleListBoxField()
    {
        $ListBox = $this->SetRequiredProperties();
        return $ListBox;
    }
    private function MappingNameListBoxField()
    {
        $ListBox = $this->SetRequiredProperties();
        $ListBox->setMappingName("ListBoxMapingName");
        return $ListBox;
    }

    private function ToolTipListBoxField()
    {
        $ListBox = $this->SetRequiredProperties();
        $ListBox->setMappingName("ListBoxMapingName");
        $ListBox->setToolTip ("ListBoxToolTip");
        return $ListBox;
    }
    private function ValuesListBoxField()
    {
        $ListBox = $this->SetRequiredProperties();
        $ListBox->setMappingName("ListBoxMapingName");
        $ListBox->setToolTip ("ListBoxToolTip");
        $values = array("PDF", "XLS", "PPT", "DOC", "DOCX");
        $ListBox->setValues ($values);
        return $ListBox;
    }
    private function SelectedIndexsListBoxField()
    {
        $ListBox = $this->SetRequiredProperties();
        $ListBox->setMappingName("ListBoxMapingName");
        $ListBox->setToolTip ("ListBoxToolTip");
        $values = array("PDF", "XLS", "PPT", "DOC", "DOCX");
        $ListBox->setValues ($values);
        $ListBox->setSelectedIndexs(array(1, 2));
        return $ListBox;
    }
    private function SetRequiredProperties()
    {
        $ListBoxFlags = array();
        $ListBoxFlags[] = "MultiSelect";
        $ListBoxFlags[] = "CommitOnSelChange";

        $Bounds = new RectangleF(['x' => 100, 'y' => 250, 'width' => 150, 'height' => 60]);
        $Name = "email_format";
        $PageIndex = 1;

        return new ListBoxField(['list_box_flags' => $ListBoxFlags, 'bounds' => $Bounds, 'name' => $Name, 'page_index' => $PageIndex]);
    }
}
